---
title: Maintainers
weight: 1
---

MetalLB was created by Dave Anderson. We are thankful for his efforts to
create MetalLB as a valuable contribution to the Kubernetes ecosystem. Ongoing
MetalLB development and maintenance is led by a team of current maintainers.

MetalLB maintainers are participants in the project with the ability to approve
changes to the MetalLB code base. The current list of maintainers can be found
in the [MetalLB CODEOWNERS
file](https://github.com/metallb/metallb/blob/main/CODEOWNERS).

## Maintainer Expectations

An active maintainer should:

* Actively participate in reviewing pull requests and incoming issues. Note
  that there are no hard rules on what is "active enough" and this is left up
  to the judgement of the current group of maintainers.

* Actively participate in discussions about design and the future of the
  project.

* Take responsibility for backports to appropriate branches for PRs they approve
  and merge.

* Do their best to follow all code, testing, and design conventions as
  determined by consensus among active maintainers.

* Gracefully step down from their maintainership role when they are no longer
  planning to actively participate in the project.

## Adding New Maintainers

New maintainers are added by consensus among the current group of maintainers.
This can be done via a private discussion via Slack or email. A majority of
maintainers should support the addition of the new person, and no single
maintainer should object to adding the new maintainer.

When adding a new maintainer, we should:

* Add to CODEOWNERS in MetalLB relevant repos (e.g. metallb and metallb-operator)
  and to the MetalLB github org itself.

* Open a PR to [github.com/cncf/foundation](https://github.com/cncf/foundation/)
  adding the maintainer there. You can use [this PR](https://github.com/cncf/foundation/pull/258/files)
  as an example of what needs to be done.

* Create an account for CNCF service desk (TODO: check how to do this and
  document it here!).

* Grant permissions on quay.io (TODO: check how to do this and document it
  here!) and bot accounts.

The new maintainer should subscribe to:

- The CNCF maintainers mailing list. For this, send an email to cncf-MetalLB-maintainers+subscribe@lists.cncf.io and
  link the merged PR that added you to the metallb CODEOWNERS.

- [MetalLB users mailing list](https://groups.google.com/g/metallb-users) and
  their membership role should be marked as owner by current maintainers.

## Removing Maintainers

It is normal for maintainers to come and go based on their other
responsibilities. Inactive maintainers may be removed if there is no
expectation of ongoing participation. If a former maintainer resumes
participation, they should be given quick consideration for re-adding to the
team.

If there becomes a conflict among maintainers that may lead to removal, active
maintainers should first work to resolve the conflict. If absolutely
necessary, a maintainer may be removed by a majority vote of existing
maintainers.

Please see all the places that a maintainer was added, to remove them. Consider
rotating any shared password if needed.
