# Custom Resources Generator

Up until release v0.12 MetalLB was configured via MetalLB's configmap.
Deprecating the configmap impacts on the users' current configurations.
To mitigate this, the MetalLB resource generator is an offline tool to
convert the configmap into the new CRDs.

## Using the generator

### Procedure

The conversion tool is shipped as a container image under `quay.io/metallb/configmaptocrs`.

In order to use the tool, the following container must be run with the ConfigMap config.yaml mapped 
into the /var/input folder. On success it will generate a resources.yaml file containing the new MetalLB CRD based config.
This example assumes MetalLB was installed in the metallb-system namespace and the ConfigMap was named config:

```bash
kubectl get configmap -n metallb-system -o yaml config > config.yaml
docker run -d -v $(pwd):/var/input quay.io/metallb/configmaptocrs
```

## Example

For this MetalLB configmap named config.yaml:

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  namespace: metallb-system
  name: config
data:
  config: |
    peers:
    - my-asn: 64512
      peer-asn: 64512
      peer-address: 10.96.0.100
    address-pools:
    - name: my-ip-space
      protocol: bgp
      addresses:
      - 198.51.100.0/24
      bgp-advertisements:
      - aggregation-length: 32
        localpref: 100
        communities:
        - 64512:1234
```

The generator will generate a `resources.yaml` file that looks like:

```yaml
# This was autogenerated by MetalLB's custom resource generator.
apiVersion: metallb.io/v1beta2
kind: BGPPeer
metadata:
  creationTimestamp: null
  name: peer1
  namespace: metallb-system
spec:
  holdTime: 1m30s
  keepaliveTime: 0s
  myASN: 64512
  passwordSecret: {}
  peerASN: 64512
  peerAddress: 10.96.0.100
status: {}
---
apiVersion: metallb.io/v1beta1
kind: IPAddressPool
metadata:
  creationTimestamp: null
  name: my-ip-space
  namespace: metallb-system
spec:
  addresses:
  - 198.51.100.0/24
status: {}
---
apiVersion: metallb.io/v1beta1
kind: BGPAdvertisement
metadata:
  creationTimestamp: null
  name: bgpadvertisement1
  namespace: metallb-system
spec:
  aggregationLength: 32
  communities:
  - 64512:1234
  ipAddressPools:
  - my-ip-space
  localPref: 100
status: {}
---
```

## Notes

Since `v0.13.11`:
Provided configmaps can contain resource names that are not compatible with 
[K8S object names](https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names) 
such as underscores or upper-case characters. They will be modified respectively to a dash and the
corresponding lowercase letter.

### Example

For this MetalLB configmap named config.yaml the address pool `My_Ip_Space` is not a valid 
resource name in K8S:

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  namespace: metallb-system
  name: config
data:
  config: |
    peers:
    - my-asn: 64512
      peer-asn: 64512
      peer-address: 10.96.0.100
    address-pools:
    - name: My_Ip_Space
      protocol: bgp
      addresses:
      - 198.51.100.0/24
      bgp-advertisements:
      - aggregation-length: 32
        localpref: 100
        communities:
        - 64512:1234
```

The generator will generate a `resources.yaml` file that looks like:

```yaml
# This was autogenerated by MetalLB's custom resource generator.
apiVersion: metallb.io/v1beta2
kind: BGPPeer
metadata:
  creationTimestamp: null
  name: peer1
  namespace: metallb-system
spec:
  holdTime: 1m30s
  keepaliveTime: 0s
  myASN: 64512
  passwordSecret: {}
  peerASN: 64512
  peerAddress: 10.96.0.100
status: {}
---
apiVersion: metallb.io/v1beta1
kind: IPAddressPool
metadata:
  creationTimestamp: null
  name: my-ip-space
  namespace: metallb-system
spec:
  addresses:
  - 198.51.100.0/24
status: {}
---
apiVersion: metallb.io/v1beta1
kind: BGPAdvertisement
metadata:
  creationTimestamp: null
  name: bgpadvertisement1
  namespace: metallb-system
spec:
  aggregationLength: 32
  communities:
  - 64512:1234
  ipAddressPools:
  - my-ip-space
  localPref: 100
status: {}
---
```

## Running directly against a cluster

Configmaptocrs tool can also run directly against a cluster,
and print the CRs corresponding to the configmap deployed on
the cluster to the standard output.
```
kubectl run configmaptocrs -n metallb-system --restart=Never -it --rm --image overriden --overrides '
{
  "spec": {
    "containers": [
      {
        "name": "configmaptocrs",
        "image": "quay.io/metallb/configmaptocrs",
        "command": [
          "/configmaptocrs",
          "-source",
          "config",
          "-only-data",
          "-stdout"
        ],
        "volumeMounts": [
          {
            "name": "config",
            "mountPath": "/var/input"
          }
        ]
      }
    ],
    "volumes": [
      {
        "name": "config",
        "configMap": {
          "name": "config"
        }
      }
    ]
  }
}'
```

## Options of configmaptocrs:
  ### -source string
    name of the input file to convert (default "./config.yaml")
  ### -only-data bool
    set this to true if the input file is only the configMap data
  ### -stdout bool
    set this to true to output the crds to stdout
