# Mercado Pago Payment Gateway Plugin (Woocommerce)

[![made-with-Php](https://img.shields.io/badge/Made%20with-Php-1f425f.svg)](https://www.php.net/) [![php-version](https://img.shields.io/badge/Php->=7.4-1f425f)]()
  
Welcome to the readme for Mercado Pago Payment Gateway Plugin. This guide is intended to provide users with the necessary information to understandand extend the functionality of the plugin.

  

## Table of Contents

1.  [Introduction](#introduction)

2.  [Plugin Overview](#plugin-overview)

3.  [WordPress and WooCommerce Basics](#wordpress-and-woocommerce-basics)

4.  [Installation](#installation)

5.  [Plugin Configuration](#plugin-configuration)

6.  [Hooks and Filters](#hooks-and-filters)

7.  [Customization](#customization)

8.  [Contributing](#contributing)

9.  [Support and Issues](#support-and-issues)

  

## Introduction

Mercado Pago Payment Gateway Plugin is a WooCommerce payment gateway extension designed to facilitate secure online transactions. This guide will help you understand the inner workings of the plugin and provide information on how to extend its functionality.

  

## Plugin Overview

  

Mercado Pago Payment Gateway Plugin integrates seamlessly with WooCommerce, enabling users to make payments using Mercado Pago. The plugin is built with flexibility and extensibility in mind, allowing developers to customize and extend its features.

  

## WordPress and WooCommerce Basics

  

To work effectively with our plugin, it's essential to have a basic understanding of WordPress and WooCommerce. If you are new to these platforms, consider familiarizing yourself with the following resources:

-  [WordPress Documentation](https://wordpress.org/documentation/)

-  [WooCommerce Documentation](https://developer.woo.com/docs/)

  

## Installation

  

Follow these steps to manual installation :

1. Download the plugin from ths GitHub repository.
2. Run `npm install` and `composer install`
3. Run `sh bin/create-release-zip.sh` to generate the final zip used to install it in the store.
4. Upload the plugin files generated by zip to the `/wp-content/plugins/` directory or install it via the WordPress admin interface.
5. Activate the plugin through the 'Plugins' menu in WordPress.


you can also get the plugin directly from the wordpress page at https://wordpress.org/plugins/woocommerce-mercadopago/

  

## Plugin Configuration


After installation, navigate to the [Mercado Pago developer site](https://www.mercadopago.com/developers/en/docs/woocommerce/introduction)  to view integration documentation and configure the plugin.
 
  

## Customization 

The WooCommerce payment plugin provides flexibility for customization and extensions. You can extend existing functionalities or add new ones according to your specific needs.

### Example Payment Gateway Extension
You can also extend the payment gateway class to add new custom gateways. See an example:
```php
namespace MercadoPago\Woocommerce\Templates\Gateways;

use MercadoPago\Woocommerce\Gateways\AbstractGateway;
use MercadoPago\Woocommerce\Templates\Transactions\ExamplePaymentTransaction;
use MercadoPago\Woocommerce\Templates\WoocommerceMercadopagoTemplate;

class ExamplePaymentGateway extends AbstractGateway {
    // ... (your code here)
}
```
In this example, the `ExamplePaymentGateway` class extends the payment gateway functionality and can be customized to add new payment options.

### Example Payment Transaction Extension

To extend the payment transaction class, you can create a custom class that inherits from `AbstractPaymentTransaction`. See the example below:

```php
namespace MercadoPago\Woocommerce\Templates\Transactions;

use MercadoPago\Woocommerce\Gateways\AbstractGateway;
use MercadoPago\Woocommerce\Transactions\AbstractPaymentTransaction;

class ExamplePaymentTransaction extends AbstractPaymentTransaction {
    // ... (your code here)
}
```
In this example, the `ExamplePaymentTransaction` class extends the payment transaction functionality and can be customized as needed.

You can see more on the github wiki page.
 
## Support and Issues

  

For any issues or questions, please  reach out to our [support team](https://www.mercadopago.com/developers/en/support/center/tickets).

  

Thank you for using  our plugin!

  

---

