---
permalink: /
---

# Usable Fonts

A list of good open-source fonts.
Not just free, but libre and with an "open source" license, like SIL [Open Font License](https://openfontlicense.org/).

Yes, making a good typeface is [expensive](https://www.thomasphinney.com/2024/06/custom-designed-typeface-cost/) and hard.
And yes, every font is usable.

- Languages and alphabets: Latin, Cyrillic, Greek. "Extended".

- Typographic features (with OpenType): small caps, old style numerals, ... If [superfamily](https://en.wikipedia.org/wiki/Font_superfamily) (or clan). If variants (condensed, ...)

- Uses: text, UI, display, code, ...

- Opinionated subset, taste, personal. _Yes, I like monospaced fonts._


## The list

In alphabetic order.

- [**Alegreya**](https://huertatipografica.com/en/fonts/alegreya-ht-pro) serif and [**Alegreya Sans**](https://huertatipografica.com/en/fonts/alegreya-sans-ht). With small-caps. Cyrillic, Greek. OFL.

- [**Andada**](https://huertatipografica.com/en/fonts/andada-ht-pro). [Site](https://andada.huertatipografica.com/)

- [**Cascadia**](https://github.com/microsoft/cascadia-code): monospaced by Microsoft. [Wikipedia](https://en.wikipedia.org/wiki/Cascadia_Code).

- [**Charis**](https://software.sil.org/charis/) by SIL. Based on [Bitstream Charter](https://en.wikipedia.org/wiki/Bitstream_Charter). (Download [Charter](https://practicaltypography.com/charter.html).) Cyrillic. OFL.

- [**Cooper Hewitt**](https://www.cooperhewitt.org/open-source-at-cooper-hewitt/cooper-hewitt-the-typeface-by-chester-jenkins/): sans-serif. OFL.

- Cousine: monospaced. Also [Liberation Mono](https://en.wikipedia.org/wiki/Liberation_fonts). Cyrillic, Greek. Apache.

- **Fira Sans** and **Fira Mono** (or Fira Code) and [FiraGO](https://bboxtype.com/typefaces/FiraGO/): sans-serif (with condensed) and monospaced, for Mozilla, by Erik Spiekermann et al. Similar to FF Meta. Good for UI. [W](https://en.wikipedia.org/wiki/Fira_(typeface)), A [review](https://typographica.org/typeface-reviews/fira-sans/). Cyrillic, Greek, [Math](https://github.com/firamath/firamath). OFL.

- [Geist](https://vercel.com/font) Sans and Mono.

- [**Gentium**](https://software.sil.org/gentium/) by SIL. [Wikipedia](https://en.wikipedia.org/wiki/Gentium). Cyrillic, Greek. OFL.

- **[IBM Plex](https://www.ibm.com/plex/) Sans**, **Serif** and **Mono** ★★★★: for IBM. [Repo](https://github.com/IBM/plex). [Wikipedia](https://en.wikipedia.org/wiki/IBM_Plex). Cyrillic, Greek, Japanese, Korean. OFL.

- [**Inconsolata**](https://levien.com/type/myfonts/inconsolata.html): monospaced.
  [Git](https://github.com/googlefonts/inconsolata) or [Git](https://github.com/google/fonts/tree/main/ofl/inconsolata), [[G]](https://fonts.google.com/specimen/Inconsolata), [[W]](https://en.wikipedia.org/wiki/Inconsolata). OFL.

- [**Inter**](https://rsms.me/inter/): sans-serif, for Figma, by Rasmus Andersson. \
  [Repo](https://github.com/rsms/inter). [Google Fonts](https://fonts.google.com/specimen/Inter). Cyrillic, Greek. [An ode](https://mattwestcott.org/blog/an-ode-to-the-inter-typeface).

- **JetBrains Mono**: monospaced. Cyrillic, Greek

- [**JuliaMono**](https://juliamono.netlify.app/): monospaced. Math.

- Lekton: monospaced

- [**Literata**](https://github.com/googlefonts/literata/): legible serif for Google Books by TypeTogether ★★★☆. [Site](https://www.type-together.com/literata-font). [Wikipedia](https://en.wikipedia.org/wiki/Literata). (Kindle has [Bookerly](https://en.wikipedia.org/wiki/Bookerly).) Cyrillic, Greek. OFL.

- **Merriweather**: semi-serif. Cyrillic.

- [**Noto**](https://notofonts.github.io/noto-docs/website/homepage/): multilanguage superfamily for Google ... [Wikipedia](https://en.wikipedia.org/wiki/Noto_fonts). [Google Fonts](https://fonts.google.com/noto). [Repo](https://github.com/notofonts). Cyrillic, Greek, Chinese, Japanese, Korean, ... OFL.

- [Overpass and Mono](https://overpassfont.org/): for Red Hat. [Wikipedia](https://en.wikipedia.org/wiki/Overpass_(typeface)). Cyrillic

- [Piazzolla](https://huertatipografica.com/en/fonts/piazzolla): serif. [Site](https://piazzolla.huertatipografica.com/). Cyrillic, Greek

- [Public Sans](https://public-sans.digital.gov/): fork of Libre Franklin

- [Recursive Sans &amp; Mono](https://www.recursive.design/): [Git](https://github.com/arrowtype/recursive/)

- [**Roboto**](https://github.com/googlefonts/roboto): system sans-serif for Google Android. (Apple has [San Francisco](https://en.wikipedia.org/wiki/San_Francisco_(sans-serif_typeface)).) [[G]](https://fonts.google.com/specimen/Roboto). Cyrillic, Greek.

- **Source Sans**, **Source Serif** and **Source Mono**: by Adobe. Cyrillic, Greek

- [**Spectral**](https://www.productiontype.com/family/spectral): for Goole Docs. [Google Fonts](https://fonts.google.com/specimen/Spectral). Cyrillic. OFL.

- STIX Two Text: serif with math. [Wikipedia](https://en.wikipedia.org/wiki/STIX_Fonts_project). Cyrillic, Greek

- **Ubuntu Sans** and **Ubuntu Mono**: system sans-serif font for Ubuntu. [Wikipedia](https://en.wikipedia.org/wiki/Ubuntu_(typeface)). Cyrillic, Greek

- [**Work Sans**](https://weiweihuanghuang.github.io/Work-Sans/). OFL.

## See also

- Free fonts: [**Font Squirrel**](https://www.fontsquirrel.com/),
  [**google-webfonts-helper**](https://gwfh.mranftl.com/),
  [indestructible type*](https://indestructibletype.com/),
  [The League of Movable Type](https://www.theleagueofmoveabletype.com/),
  [Open Font Library](https://fontlibrary.org/).

## License

[CC0 1.0 Universal](https://creativecommons.org/publicdomain/zero/1.0/) "No Rights Reserved"
