# SPDX-FileCopyrightText: © 2022 Melg Eight <public.melg8@gmail.com>
#
# SPDX-License-Identifier: MIT

# Add new cxx flags to existing cxx flags.
function(add_compiler_flags flags)
  foreach(flag ${flags})
    set(CMAKE_CXX_FLAGS
        "${CMAKE_CXX_FLAGS} ${flag}"
        PARENT_SCOPE)
  endforeach()
endfunction()

if(${ENABLE_COVERAGE})
  add_compiler_flags(--coverage)
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES "GNU|Clang")
  add_compiler_flags(-fno-rtti)
  add_compiler_flags(-fno-exceptions)

  add_compiler_flags(-fsanitize=address,undefined)
  add_compiler_flags(-Werror)
  add_compiler_flags(-Wno-c++98-compat)
  add_compiler_flags(-Wno-c++98-compat-pedantic)
  add_compiler_flags(-Wpedantic)
  add_compiler_flags(-pedantic-errors)
  add_compiler_flags(-Wno-old-style-cast)
  add_compiler_flags(-Wno-sign-conversion)
  add_compiler_flags(-Wcast-qual)
  add_compiler_flags(-Wunused-parameter)
  add_compiler_flags(-Wshadow)
  add_compiler_flags(-Wundef)
  add_compiler_flags(-Wno-switch-enum)
  add_compiler_flags(-fstrict-aliasing)
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES "GNU")
  add_compiler_flags(-Wall)
  add_compiler_flags(-Wextra)
  add_compiler_flags(-fdiagnostics-show-option)
  add_compiler_flags(-Wno-conversion)
  add_compiler_flags(-Wfloat-equal)
  add_compiler_flags(-Wlogical-op)
  add_compiler_flags(-Wredundant-decls)
  add_compiler_flags(-Wstrict-overflow=5)
  add_compiler_flags(-Wno-strict-overflow)
  add_compiler_flags(-Wwrite-strings)
  add_compiler_flags(-Wpointer-arith)
  add_compiler_flags(-Wformat=2)
  add_compiler_flags(-Wno-switch-default)
  add_compiler_flags(-Wmissing-include-dirs)
  add_compiler_flags(-Wcast-align)
  add_compiler_flags(-Wnon-virtual-dtor)
  add_compiler_flags(-Wctor-dtor-privacy)
  add_compiler_flags(-Wdisabled-optimization)
  add_compiler_flags(-Wno-inline)
  add_compiler_flags(-Winvalid-pch)
  add_compiler_flags(-Wmissing-declarations)
  add_compiler_flags(-Woverloaded-virtual)
  add_compiler_flags(-Wunused-variable)
  add_compiler_flags(-fvar-tracking-assignments)

  if(NOT CMAKE_CXX_COMPILER_VERSION VERSION_LESS 4.6)
    add_compiler_flags(-Wnoexcept)
  endif()

  if(NOT CMAKE_CXX_COMPILER_VERSION VERSION_LESS 5.0)
    add_compiler_flags(-Wdouble-promotion)
    add_compiler_flags(-Wtrampolines)
    add_compiler_flags(-Wzero-as-null-pointer-constant)
    add_compiler_flags(-Wno-useless-cast)
    add_compiler_flags(-Wvector-operation-performance)
    add_compiler_flags(-Wsized-deallocation)
  endif()

  if(CMAKE_CXX_COMPILER_VERSION VERSION_EQUAL 6.0 OR CMAKE_CXX_COMPILER_VERSION
                                                     VERSION_GREATER 6.0)
    add_compiler_flags(-Wshift-overflow=2)
    add_compiler_flags(-Wnull-dereference)
    add_compiler_flags(-Wduplicated-cond)
  endif()
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES "Clang")
  add_compiler_flags(-Weverything)
  add_compiler_flags(-Wextra-semi-stmt)
  add_compiler_flags(-Wmissing-noreturn)
  add_compiler_flags(-Wcovered-switch-default)
  add_compiler_flags(-Wunreachable-code)
  add_compiler_flags(-Wcomma)
  add_compiler_flags(-Wimplicit-fallthrough)
  add_compiler_flags(-Wunused-variable)
  add_compiler_flags(-Wmissing-variable-declarations)
  add_compiler_flags(-Wenum-enum-conversion)
  add_compiler_flags(-Wfloat-conversion)
  add_compiler_flags(-Wunused-macros)
  add_compiler_flags(-Wno-reserved-id-macro)
  add_compiler_flags(-Wzero-as-null-pointer-constant)
  add_compiler_flags(-Wextra-semi)
  add_compiler_flags(-Wno-shorten-64-to-32)
  add_compiler_flags(-Wno-weak-vtables)
  add_compiler_flags(-Wno-exit-time-destructors)
  add_compiler_flags(-Wshift-sign-overflow)
  add_compiler_flags(-Wredundant-parens)
  add_compiler_flags(-Warray-bounds-pointer-arithmetic)
  add_compiler_flags(-Wtautological-unsigned-enum-zero-compare)
  add_compiler_flags(-Wtautological-type-limit-compare)
  add_compiler_flags(-Wdeprecated-copy-dtor)
  add_compiler_flags(-Wunused-exception-parameter)
  add_compiler_flags(-Wunreachable-code-return)
  add_compiler_flags(-Wconditional-uninitialized)
  add_compiler_flags(-Wshadow-field)
  add_compiler_flags(-Wmissing-prototypes)
  add_compiler_flags(-Wimplicit-int-conversion)
  add_compiler_flags(-Wno-padded)
  add_compiler_flags(-Wstring-concatenation)
  add_compiler_flags(-Wsuggest-override)
  add_compiler_flags(-Winconsistent-missing-override)
  add_compiler_flags(-Wsuggest-destructor-override)
  add_compiler_flags(-Qunused-arguments -fcolor-diagnostics)
  add_compiler_flags(-Wno-c++17-extensions)
  add_compiler_flags(-Wno-global-constructors)
  add_compiler_flags(-Wno-used-but-marked-unused)
  if(NOT APPLE)
    if(CMAKE_CXX_COMPILER_VERSION VERSION_EQUAL 13.0
       OR CMAKE_CXX_COMPILER_VERSION VERSION_GREATER 13.0)
      add_compiler_flags(-Wno-reserved-identifier)
    endif()
  endif()
endif()
