% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Basic_Functions.R
\name{generateBulk_norep}
\alias{generateBulk_norep}
\title{Construct Pseudo bulk samples -- random}
\usage{
generateBulk_norep(
  eset,
  ct.varname,
  sample,
  disease = NULL,
  ct.sub,
  prop_mat = NULL,
  nbulk = 10,
  samplewithRep = F
)
}
\arguments{
\item{eset}{ExpressionSet object for single cells}

\item{ct.varname}{variable name for 'cell types'}

\item{sample}{variable name for subject/samples}

\item{disease}{indicate the health condition of subjects}

\item{ct.sub}{a subset of cell types that are selected to construct pseudo bulk samples. If NULL, then all cell types are used.}

\item{prop_mat}{manually input the cell-type proportion for pseudo bulk samples}

\item{nbulk}{number of pseudo bulk samples to be constructed}

\item{samplewithRep}{logical, randomly sample single cells with replacement. Default is F.}
}
\value{
pseudo bulk samples ExpressionSet, and actual cell-type proportions
}
\description{
Construct Pseudo bulk samples by random sampled number of cells per subject, but based on the actual numbers.
}
