% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deconvolution.R
\name{deconv_simple}
\alias{deconv_simple}
\title{Simple deconvolution function using W-NNLS}
\usage{
deconv_simple(
  count.filter.norm,
  basis.norm,
  iter.max = 2000,
  nu = 1e-10,
  epsilon = 0.001,
  truep = NULL
)
}
\arguments{
\item{count.filter.norm}{Normalized count matrix for bulk samples. Genes by samples.}

\item{basis.norm}{Basis matrix calculated from single cell samples. Genes by cell-types.}

\item{iter.max}{the maximum number of iteration in WNNLS}

\item{nu}{a small constant to facilitate the calculation of variance}

\item{epsilon}{a small constant number used for convergence criteria}

\item{truep}{true cell-type proportions for bulk samples if known}
}
\value{
Estimated proportion-prop.est.mvw for bulk samples
}
\description{
Deconvolution using pre-normalized count matrix and pre-calculated basis matrix.
}
