% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deconvolution.R
\name{SCDC_qc}
\alias{SCDC_qc}
\title{Clustering QC}
\usage{
SCDC_qc(
  sc.eset,
  ct.varname,
  sample,
  scsetname = "Single Cell",
  ct.sub,
  iter.max = 1000,
  nu = 1e-04,
  epsilon = 0.01,
  arow = NULL,
  qcthreshold = 0.7,
  generate.figure = T,
  ct.cell.size = NULL,
  cbPalette = c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2",
    "#D55E00", "#CC79A7"),
  ...
)
}
\arguments{
\item{sc.eset}{ExpressionSet object for single cells}

\item{ct.varname}{variable name for 'cell type'}

\item{sample}{variable name for subject/sample}

\item{scsetname}{the name for the single cell dataset}

\item{ct.sub}{a subset of cell types that are selected to construct basis matrix}

\item{iter.max}{the maximum number of iteration in WNNLS}

\item{nu}{a small constant to facilitate the calculation of variance}

\item{epsilon}{a small constant number used for convergence criteria}

\item{arow}{annotation of rows for pheatmap. Should be a variable name, like "sample" or "Subject".}

\item{qcthreshold}{the probability threshold used to filter out questionable cells}

\item{generate.figure}{logical. If generate the heatmap by pheatmap or not. default is TRUE.}

\item{ct.cell.size}{default is NULL, which means the "library size" is calculated based on the data. Users can specify a vector of cell size factors corresponding to the ct.sub according to prior knowledge. The vector should be named: names(ct.cell.size input) should not be NULL.}
}
\value{
a list including: 1) a probability matrix for each single cell input; 2) a clustering QCed ExpressionSet object; 3) a heatmap of QC result.
}
\description{
Single cells Clustering QC
}
