% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deconvolution.R
\name{SCDC_prop_ONE_subcl_marker}
\alias{SCDC_prop_ONE_subcl_marker}
\title{Tree-guided proportion estimation for ONE subject}
\usage{
SCDC_prop_ONE_subcl_marker(
  bulk.eset,
  sc.eset,
  ct.varname,
  fl.varname,
  sample,
  truep = NULL,
  ct.sub = NULL,
  ct.fl.sub,
  iter.max = 3000,
  nu = 1e-04,
  epsilon = 0.001,
  weight.basis = F,
  bulk_disease = NULL,
  select.marker = T,
  markers = NULL,
  marker.varname = NULL,
  pseudocount.use = 1,
  LFC.lim = 0.5,
  allgenes.fl = F,
  ct.cell.size = NULL,
  fl.cell.size = NULL,
  ...
)
}
\arguments{
\item{bulk.eset}{ExpressionSet object for bulk samples}

\item{sc.eset}{ExpressionSet object for single cell samples}

\item{ct.varname}{variable name for 'cell types'}

\item{fl.varname}{variable name for first-level 'meta-clusters'}

\item{sample}{variable name for subject/samples}

\item{truep}{true cell-type proportions for bulk samples if known}

\item{ct.sub}{a subset of cell types that are selected to construct basis matrix}

\item{ct.fl.sub}{'cell types' for first-level 'meta-clusters'}

\item{iter.max}{the maximum number of iteration in WNNLS}

\item{nu}{a small constant to facilitate the calculation of variance}

\item{epsilon}{a small constant number used for convergence criteria}

\item{weight.basis}{logical, use basis matrix adjusted by MVW, default is T.}

\item{select.marker}{logical, select marker genes to perform deconvolution in tree-guided steps. Default is T.}

\item{markers}{A set of marker gene that input manully to be used in deconvolution. If NULL, then}

\item{marker.varname}{variable name of cluster groups when selecting marker genes. If NULL, then use ct.varname.}

\item{pseudocount.use}{a constant number used when selecting marker genes, default is 1.}

\item{LFC.lim}{a threshold of log fold change when selecting genes as input to perform Wilcoxon's test.}

\item{allgenes.fl}{logical, use all genes in the first-level deconvolution}

\item{ct.cell.size}{default is NULL, which means the "library size" is calculated based on the data. Users can specify a vector of cell size factors corresponding to the ct.sub according to prior knowledge. The vector should be named: names(ct.cell.size input) should not be NULL.}

\item{fl.cell.size}{default is NULL, similar to ct.cell.size. This is for first-level 'meta-clusters'.}
}
\value{
Estimated proportion, basis matrix, predicted gene expression levels for bulk samples
}
\description{
Proportion estimation function for ONE-subject case, and apply tree-guided deconvolution
}
