% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENSEMBLE.R
\name{SCDC_ENSEMBLE}
\alias{SCDC_ENSEMBLE}
\title{ENSEMBLE function}
\usage{
SCDC_ENSEMBLE(
  bulk.eset,
  sc.eset.list = NULL,
  ct.varname,
  sample,
  ct.sub,
  grid.search = F,
  search.length = 0.05,
  iter.max = 2000,
  nu = 1e-04,
  epsilon = 0.001,
  truep = NULL,
  weight.basis = T,
  prop.input = NULL,
  Transform_bisque = F,
  ct.cell.size = NULL,
  ...
)
}
\arguments{
\item{bulk.eset}{ExpressionSet object for bulk samples}

\item{sc.eset.list}{list of ExpressionSet objects for single cell reference datasets. Note that the variable names of multiple ExpressionSet objects should be consistent. Not required if prop.input is specified.}

\item{ct.varname}{character string specifying the variable name for 'cell types'. Not required if prop.input is specified.}

\item{sample}{character string specifying the variable name for subject/samples. Not required if prop.input is specified.}

\item{ct.sub}{vector. a subset of cell types that are selected to construct basis matrix. Not required if prop.input is specified.}

\item{grid.search}{logical. whether to allow grid search method to derive the ENSEMBLE weights.}

\item{search.length}{a number between 0 to 0.5. if using "Grid search", the step length used. Smaller search.length derives more accurate optimization results.}

\item{iter.max}{the maximum number of iteration in WNNLS}

\item{nu}{a small constant to facilitate the calculation of variance}

\item{epsilon}{a small constant number used for convergence criteria}

\item{truep}{true cell-type proportions for bulk samples if known}

\item{prop.input}{A list of SCDC_prop objects. Default is NULL. Users can use the SCDC function CreateSCDCpropObj to create the SCDC_prop objects first, and then put all objects into a list as this input. This allows users to ENSEMBLE results calculated from other deconvolution methods.}

\item{ct.cell.size}{default is NULL, which means the "library size" is calculated based on the data. Users can specify a vector of cell size factors corresponding to the ct.sub according to prior knowledge. The vector should be named: names(ct.cell.size input) should not be NULL.}
}
\description{
ENSEMBLE function for deconvolution results output from SCDC_prop.
}
