# ASP.NET DictionaryEngine
Feature rich, socially connected, open-source dictionary, wiki post application written in asp.net core platform, that can help you build user / search engine friendly wiki / glossary / dictionary solution for any topic serve within existing application or as standalone application.

DictionaryEngine is a lighter, portable script for building socially connected online dictionary, glossary, wiki posts type application for specific topics or broad topic.

Such type of application can act as glossary that make a useful catalog of information dictionary within your application.

It can be easily integrated in your existing solution.

This project is currently built with ASP.NET Core 3.1 + Angular 9.0.2 + Bootstrap 4.4.1

### [Product Demo](http://dictionaryengine.aspnetprojects.com/ "Product Demo")

### [Product Home & Documentation](https://www.mediasoftpro.com/documentation/dictionaryengine "Product Home & Documentation")

### Features

List of main features includes
- **MEMBERSHIP**: Extended ASP.NET Identity Module that can allow users to create account, login, manage account, update profile, change password, email etc
- **DICTIONARY**: Allow site administrator or user to manage unlimited dictionary, glossary or wiki topics with numerous actions.
- **MY ACCOUNT**: Advance my-account application (Angular based) that can allow users to manage profile, settings and configurations.
- **CONTROL PANEL**: Advance control panel (single page latest angular based) that can help site administrator to manage website settings, configurations, contents, users, reports etc.
- **CONFIGURATIONS**: Support advance configuration section that can allow you configure almost every available features on the fly without making changes in code.
- **INSTALLATION**: Single step easy installation module that can help you easily configure database, default admin user, initialize application with default settings to make your application ready to use.
- **MULTIPLE LANGUAGES**: Support managing multiple ui cultures, configure your default language and allow multiple language options for user to choose from.
- **CATEGORIES**: It support advance category managing module that can allow you to manage unlimited categories with unlimited hierarchy and separate it for each type of contents.
- **LABELS**: It support labeling or tagging articles, blogs with one or more labels or tags. Also have advance tag cloud management tool to manage labels, group labels by priority etc
- **ADVERTISEMENT**: It support managing advertisement (e.g Adsense Script) from control panel for different types of blocks that display / render ads on different sections and pages.
- **ADVANCE SEARCH**: Angular based real time search module that can allow users to search dictionary topics, glossary or wiki posts and more.
- **SITEMAPS**: It support dynamically generated sitemaps from dictionary topics, pages, categories, tags etc, that can be easily submitted to search engines to index your data and pages fastly.
- **MAIL TEMPLATES**: It support advance mail template tool that can help you manage and customize mail templates from control panel.
- **REPORTS**: It include advance reporting module that can help site administrator to view different type of reports e.g display dictionary posted and actions taken trends monthly bases for current year.
- **ABUSE REPORT**: It include abuse / spam reporting functionality and management module in control panel that can help administrator to review and take action on reports sent from website.
- **ERROR LOG**: It include advance error logging module, that can log almost every type of error occurs while user browsing the site and report to site administrator for review.
- **DICTIONARY**: It include dictionary module that can allow administrator to manage restricted usernames and black listed word that later used by screening script to prevent website from contents what may violate its terms of use.
- **DYNAMIC ATTRIBUTES**: It include advance dynamic profile attribute management tool that can help site administrator to adjust user profile attributes from control panel without making changes in code.
- **BLOCK IP**: It include optional module that can allow site administrator to manage, block ip-address to access and use website.
- **ROOT PAGES**: Advance single routing and friendly url logic designed to make almost every page url act as root url without using separate controllers / actions.

### Installation & Configuration
Project include installation wizard that can help you configure and run your application, for more detail visit product [Installation & Configuration](https://www.mediasoftpro.com/docs/documentation/740/aspnet-dictionaryengine-installation "Installation & Configuration") page.

### Documentation & Support
For product documentation and support, please visit [Documentation](https://www.mediasoftpro.com/documentation/dictionaryengine "Documentation") page.

# Feedbacks & Contribution
You are warmly welcome to give feedback, report bugs and propose new ideas.

### Report Bugs
If you want to report a new bug, please check if the bug isn´t already reported. In case there is no similar issue, please open a new issue with the label Bug.

### Contribute
Checkout [CONTRIBUTING.md](https://github.com/mediasoftpro/dictionaryengine/blob/master/CONTRIBUTING.md "CONTRIBUTING.md") document for more detail.

### Donate
If you like our product and contribute in the form of donation, [click here](https://github.com/mediasoftpro/dictionaryengine/blob/master/DONATE.md "click here") for more detail.

