/* -------------------------------------------------------------------------- */
/*                        Product Name: DictionaryEngine                      */
/*                            Author: Mediasoftpro                            */
/*                       Email: support@mediasoftpro.com                      */
/*       License: Read license.txt located on root of your application.       */
/*                     Copyright 2007 - 2020 @Mediasoftpro                    */
/* -------------------------------------------------------------------------- */

import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { RouterModule } from "@angular/router";

// shared modules
import { PartialModule } from "../../partials/shared.module";

// components
import { ListComponent } from "./component/main/partials/list.component";
import { MainAbuseReportComponent } from "./component/main/main.component";

// services
import { SettingsService } from "./services/settings.service";
import { DataService } from "./services/data.service";
import { FormService } from "./services/form.service";

/* actions */
import { AbuseReportActions } from "../../reducers/reports/abuse/actions";

@NgModule({
  imports: [
    CommonModule,
    PartialModule,
    RouterModule,
    FormsModule,
    ReactiveFormsModule
  ],
  declarations: [
    ListComponent,
    MainAbuseReportComponent,
  ],
  exports: [
    ListComponent,
    MainAbuseReportComponent
  ],
  providers: [SettingsService, DataService, FormService, AbuseReportActions]
})
export class SharedAbuseReportModule {}
