/* -------------------------------------------------------------------------- */
/*                        Product Name: DictionaryEngine                      */
/*                            Author: Mediasoftpro                            */
/*                       Email: support@mediasoftpro.com                      */
/*       License: Read license.txt located on root of your application.       */
/*                     Copyright 2007 - 2020 @Mediasoftpro                    */
/* -------------------------------------------------------------------------- */

import { Component } from "@angular/core";

@Component({
  selector: "app-spinner05",
  template: `
    <div class="spinner">
      <div class="cube1"></div>
      <div class="cube2"></div>
    </div>
  `,
  styles: [
    `
      .spinner {
        margin: 100px auto;
        width: 40px;
        height: 40px;
        position: relative;
      }

      .cube1,
      .cube2 {
        background-color: #fb008b;
        width: 15px;
        height: 15px;
        position: absolute;
        top: 0;
        left: 0;

        -webkit-animation: sk-cubemove 1.8s infinite ease-in-out;
        animation: sk-cubemove 1.8s infinite ease-in-out;
      }

      .cube2 {
        -webkit-animation-delay: -0.9s;
        animation-delay: -0.9s;
      }

      @-webkit-keyframes sk-cubemove {
        25% {
          -webkit-transform: translateX(42px) rotate(-90deg) scale(0.5);
        }
        50% {
          -webkit-transform: translateX(42px) translateY(42px) rotate(-180deg);
        }
        75% {
          -webkit-transform: translateX(0px) translateY(42px) rotate(-270deg)
            scale(0.5);
        }
        100% {
          -webkit-transform: rotate(-360deg);
        }
      }

      @keyframes sk-cubemove {
        25% {
          transform: translateX(42px) rotate(-90deg) scale(0.5);
          -webkit-transform: translateX(42px) rotate(-90deg) scale(0.5);
        }
        50% {
          transform: translateX(42px) translateY(42px) rotate(-179deg);
          -webkit-transform: translateX(42px) translateY(42px) rotate(-179deg);
        }
        50.1% {
          transform: translateX(42px) translateY(42px) rotate(-180deg);
          -webkit-transform: translateX(42px) translateY(42px) rotate(-180deg);
        }
        75% {
          transform: translateX(0px) translateY(42px) rotate(-270deg) scale(0.5);
          -webkit-transform: translateX(0px) translateY(42px) rotate(-270deg)
            scale(0.5);
        }
        100% {
          transform: rotate(-360deg);
          -webkit-transform: rotate(-360deg);
        }
      }
    `
  ]
})
export class Spinner5Component {}
