# Accessibility

## Overview
This plugin enables special accessibility features for adding an audio description or sign language annotated movie file. 

## Keyword to use it
```javascript
features: [..., 'a11y']
```

## API
Parameter | Type | Default | Description
------ | --------- | ------- | --------
`data-video-description` | array | null | An array of video source objects like `{ src: "description.mp4", type: "video/mp4" }`. This plugin will evaluate the best matching type out of the array.
`data-audio-description` | array | null | An array of audio description source objects like `{ src: "description.mp3", type: "audio/mp3" }`. This plugin will evaluate the best matching type out of the array.
`data-audio-description-voiceover` | boolean | false | If set as data attribute only or with value `true` audio description will be started in voice-over mode.
`iconSpritePathA11y` | string | `mejs-a11y-icons.svg` | Path for the SVG icon sprite file.

#### Audio-description node
The Audio description node is bound to the MediaElement.js object at `mejs.audioDescription.node`, like the original node is bound under `mejs.node`.

## Icons
The sign language and audio description icon were made by [Font Awesome](https://fontawesome.com) and underlie the following [License](https://fontawesome.com/license).

---

This Plugin is sponsored by [Aktion Mensch e.V.](https://www.aktion-mensch.de)

---

## German Translation

### Übersicht
Dieses Plugin ermöglicht besondere Barrierefreiheit-Erweiterungen zum Hinzufügen von Audio-Deskription oder Videos mit Übersetzung in Gebärdensprache.

### Keyword zum Einbinden
```javascript
features: [..., 'a11y']
```

### API
Parameter | Type | Default | Beschreibung
------ | --------- | ------- | --------
`data-video-description` | array | null | Ein Array von Gebärden-Sprachen-Video-Source Objekten, die wie folgt auszusehen haben: `{ src: "description.mp4", type: "video/mp4" }`. Das Plugin wählt die am besten passende Video-Source aus dem Array aus.
`data-audio-description` | array | null | Ein Array von Audio-Deskription-Source Objekten, die wie folgt auszusehen haben: `{ src: "description.mp3", type: "audio/mp3" }`. Das Plugin wählt die am besten passende Audio-Source aus dem Array aus.
`data-audio-description-voiceover` | boolean | false | Wenn der Parameter als Data-Attribut gesetzt oder mit dem Wert `true` belegt ist, wird die Audio-Deskription als Voice-Over gestartet.

##### Audio-Deskription Node
Der Audio-Deskription Node wird im MediaElement.js Objekt unter `mejs.audioDescription.node` eingebunden, so wie der eigentliche Node unter `mejs.node` eingebunden ist.

### Icons
Das Gebärdensprache- und Audio-Deskriptions-Icon stammen von [Font Awesome](https://fontawesome.com) und unterliegen der folgenden [Lizenz](https://fontawesome.com/license).


---

Dieses Plugin wurde gesponsert von [Aktion Mensch e.V.](https://www.aktion-mensch.de)
