/*!
 * MediaElement.js
 * http://www.mediaelementjs.com/
 *
 * Wrapper that mimics native HTML5 MediaElement (audio and video)
 * using a variety of technologies (pure JavaScript, Flash, iframe)
 *
 * Copyright 2010-2017, John Dyer (http://j.hn/)
 * License: MIT
 *
 */
!function r(s,a,d){function u(i,e){if(!a[i]){if(!s[i]){var o="function"==typeof require&&require;if(!e&&o)return o(i,!0);if(c)return c(i,!0);var t=new Error("Cannot find module '"+i+"'");throw t.code="MODULE_NOT_FOUND",t}var n=a[i]={exports:{}};s[i][0].call(n.exports,function(e){return u(s[i][1][e]||e)},n,n.exports,r,s,a,d)}return a[i].exports}for(var c="function"==typeof require&&require,e=0;e<d.length;e++)u(d[e]);return u}({1:[function(e,i,o){"use strict";mejs.i18n.en["mejs.a11y-audio-description"]="Toggle audio description",mejs.i18n.en["mejs.a11y-video-description"]="Toggle sign language",Object.assign(mejs.MepDefaults,{videoDescriptionToggled:!1,audioDescriptionToggled:!1,defaultSource:null,audioDescriptionSource:null,videoDescriptionSource:null,isPlaying:!1,isVoiceover:!1,audioDescriptionCanPlay:!1,iconSpritePathA11y:"mejs-a11y-icons.svg"}),Object.assign(MediaElementPlayer.prototype,{builda11y:function(){var e=this;e.options.defaultSource={src:e.node.src,type:e.node.type},e.options.isVoiceover=e._loadBooleanFromAttribute("data-audio-description-voiceover"),e.options.audioDescriptionSource=e._loadSourceFromAttribute("data-audio-description"),e.options.videoDescriptionSource=e._loadSourceFromAttribute("data-video-description"),e.options.audioDescriptionSource&&e._createAudioDescription(),e.options.videoDescriptionSource&&e._createVideoDescription(),e.media.addEventListener("play",function(){return e.options.isPlaying=!0}),e.media.addEventListener("playing",function(){return e.options.isPlaying=!0}),e.media.addEventListener("pause",function(){return e.options.isPlaying=!1}),e.media.addEventListener("ended",function(){return e.options.isPlaying=!1})},_getFirstChildNodeByClassName:function(e,i){return[].concat(function(e){if(Array.isArray(e)){for(var i=0,o=Array(e.length);i<e.length;i++)o[i]=e[i];return o}return Array.from(e)}(e.childNodes)).find(function(e){return-1<e.className.indexOf(i)})},_generateIconHtml:function(e,i,o,t){return'<svg xmlns="http://www.w3.org/2000/svg" id="'+e+'" class="'+i+t+'" aria-hidden="true" focusable="false">\n            <use xlink:href="'+o+"#"+t+'"></use></svg>'},_createAudioDescription:function(){var e=this,i=e._generateIconHtml(e.id,e.options.classPrefix,e.options.iconSpritePathA11y,"icon-audio"),o=mejs.i18n.t("mejs.a11y-audio-description"),t=document.createElement("div");t.className=e.options.classPrefix+"button "+e.options.classPrefix+"audio-description-button",t.innerHTML='<button type="button" aria-controls="'+e.id+'" title="'+o+'" aria-label="'+o+'" tabindex="0">'+i+"</button>",e.addControlElement(t,"audio-description"),t.addEventListener("click",function(){e.options.audioDescriptionToggled=!e.options.audioDescriptionToggled,mejs.Utils.toggleClass(t,"audio-description-on"),e._toggleAudioDescription()})},_createVideoDescription:function(){var e=this,i=e._generateIconHtml(e.id,e.options.classPrefix,e.options.iconSpritePathA11y,"icon-video"),o=mejs.i18n.t("mejs.a11y-video-description"),t=document.createElement("div");t.className=e.options.classPrefix+"button "+e.options.classPrefix+"video-description-button",t.innerHTML='<button type="button" aria-controls="'+e.id+'" title="'+o+'" aria-label="'+o+'" tabindex="0">'+i+"</button>",e.addControlElement(t,"video-description"),t.addEventListener("click",function(){e.options.videoDescriptionToggled=!e.options.videoDescriptionToggled,mejs.Utils.toggleClass(t,"video-description-on"),e._toggleVideoDescription()})},_loadSourceFromAttribute:function(i){if(!this.node.hasAttribute(i))return null;var e,o=void 0;try{var t=this.node.getAttribute(i);o=JSON.parse(t)}catch(e){console.error("error loading "+i+": "+e.message)}finally{e=o}return e?this._evaluateBestMatchingSource(e):null},_loadBooleanFromAttribute:function(e){if(!this.node.hasAttribute(e))return!1;var i=this.node.getAttribute(e);return"true"===i||""===i},_evaluateBestMatchingSource:function(e){var t=this,i=function(e){return o=e.type,i=mejs.Utils.getMimeFromType(o),t.node.canPlayType(i);var i,o},o=e.find(function(e){return"probably"===i(e)});if(o)return o;var n=e.find(function(e){return"maybe"===i(e)});return n||null},_createAudioDescriptionPlayer:function(){var o=this,e=document.createElement("audio");if(e.setAttribute("preload","auto"),e.classList.add(o.options.classPrefix+"audio-description-player"),e.setAttribute("src",o.options.audioDescriptionSource.src),e.setAttribute("type",o.options.audioDescriptionSource.type),e.load(),document.body.appendChild(e),o.audioDescription=new mejs.MediaElementPlayer(e,{features:["volume"],audioVolume:o.options.videoVolume,startVolume:o.node.volume,pauseOtherPlayers:!1,iconSprite:o.options.iconSprite,fakeNodeName:o.options.fakeNodeName||"mediaelementwrapper"}),o.audioDescription.node.addEventListener("canplay",function(){return o.options.audioDescriptionCanPlay=!0}),o.media.addEventListener("play",function(){return o.audioDescription.node.play().catch(function(e){return console.error(e)})}),o.media.addEventListener("playing",function(){return o.audioDescription.node.play().catch(function(e){return console.error(e)})}),o.media.addEventListener("pause",function(){return o.audioDescription.node.pause()}),o.media.addEventListener("waiting",function(){return o.audioDescription.node.pause()}),o.media.addEventListener("ended",function(){return o.audioDescription.node.pause()}),o.media.addEventListener("timeupdate",function(){var e=.35<Math.abs(o.currentTime-o.audioDescription.node.currentTime),i=o.options.audioDescriptionCanPlay;e&&i&&(o.audioDescription.node.currentTime=o.currentTime)}),o.options.isVoiceover)o.media.addEventListener("volumechange",function(){return o.audioDescription.node.volume=o.node.volume});else{var i=o.options.classPrefix+"volume-button",t=o._getFirstChildNodeByClassName(o.controls,i);if(o.videoVolumeButton=t){var n=o._getFirstChildNodeByClassName(o.audioDescription.controls,i);t.classList.add("hidden"),o.controls.insertBefore(n,t.nextSibling),o.descriptiveVolumeButton=n}}},_toggleAudioDescription:function(){var e=this;e.audioDescription||e._createAudioDescriptionPlayer(),e.options.audioDescriptionToggled?(e.audioDescription.node.volume=e.volume,e.options.isPlaying&&e.audioDescription&&(e.audioDescription.node.muted=!1,e.audioDescription.node.play().catch(function(e){return console.error(e)})),e.options.isVoiceover||(e.muted=!0,e.audioDescription.node.muted=!1),!e.options.isVoiceover&&e.videoVolumeButton&&e.descriptiveVolumeButton&&(mejs.Utils.addClass(e.videoVolumeButton,"hidden"),mejs.Utils.removeClass(e.descriptiveVolumeButton,"hidden"))):(e.volume=e.audioDescription.node.volume,e.audioDescription.node.pause(),e.audioDescription.node.muted=!0,e.options.isVoiceover||(e.muted=!1,e.audioDescription.node.muted=!0),!e.options.isVoiceover&&e.videoVolumeButton&&e.descriptiveVolumeButton&&(mejs.Utils.removeClass(e.videoVolumeButton,"hidden"),mejs.Utils.addClass(e.descriptiveVolumeButton,"hidden")))},_toggleVideoDescription:function(){var e=this,i=e.node.currentTime,o=e.options.isPlaying,t=e.options.videoDescriptionToggled;e.node.pause(),e.node.src=t?e.options.videoDescriptionSource.src:e.options.defaultSource.src,e.node.type=t?e.options.videoDescriptionSource.type:e.options.defaultSource.type,e.node.load(),o?e.node.play().then(function(){return e.node.currentTime=i}).catch(function(e){return console.error(e)}):e.node.setCurrentTime(i)}})},{}]},{},[1]);