# WebExtension Webpack Example
A minimal example of how to use [webpack](https://webpack.github.io) to package
[npm](https://npmjs.com) modules so they can be used in a WebExtension.
The example package used by this extension is `left-pad`, an essential package
in almost any situation.

## What it does
This example shows how to use a node module in a background script and popup.
It defines two build targets in [webpack.config.js](webpack.config.js), they each
generate a file that includes all modules used the entry point and store it in
the [addon](addon/) folder. The first one starts with [background_scripts/background.js](background_scripts/background.js)
and stores it in `addon/background_scripts/index.js`. The other one does the
same for [popup/left-pad.js](popup/left-pad.js) and stores it in `addon/popup/index.js`.

The extension includes a browser action with a popup, which provides an UI for
running left-pad on a string with a chosen character. The operation can either be
performed with the left-pad module included in the panel's script or in the
background script.

## What it could do
This could be infinitely extended - injecting global jQuery, adding babel,
react/jsx, css modules, image processing, local modules and so on.

## What it shows

 - How to use npm or custom modules in a WebExtension.

## How to build it

 - `npm install`
 - `npm run build`

The WebExtension in the [addon](addon/) folder should now work.

## What about Browserify?
[Browserify](http://browserify.org/) works just as well as webpack for extensions. In the end it's a
personal choice about your preferred tool.

## Live-development
As well as watching the folder with your `manifest.json` in it, you will also
have to run webpack in watch mode. You can use the
[webpack-webext-plugin](https://github.com/rpl/webpack-webext-plugin) to simplify the workflow.

## On addons.mozilla.org Reviews
Files generated by webpack and friends are compiled files. You have to separately [upload the source](https://developer.mozilla.org/en-US/Add-ons/AMO/Policy/Reviews#Source_Code_Submission) you generated your extension from to AMO for review of a listed extension. This will mean that your extension has to be reviewed by an admin reviewer, which will result in a longer wait time in queue.

To make the review easier, you can exclude third-party libraries from your output and directly ship the original distribution files for the libraries. This allows AMO to automatically recognize libraries and mark them as safe. This can be achieved with [externals](https://webpack.js.org/configuration/externals/) in the configuration for webpack.
