/*!
* TW Elements React
* Version: 1.0.0-alpha-end
* 
* Copyright: Material Design for Bootstrap
* https://mdbootstrap.com/
* 
* Read the license: https://tw-elements.com/license/
*
*
* Documentation: https://tw-elements.com/docs/react/
*
* Support: https://mdbootstrap.com/support/cat/twe
*
* Contact: tailwind@mdbootstrap.com
* 
*/

import { jsx as v, jsxs as ne, Fragment as be } from "react/jsx-runtime";
import ue, { useState as E, useRef as P, useEffect as C, useCallback as oe, createContext as je, useContext as me, useImperativeHandle as Tt, Children as Lt, cloneElement as _t, useMemo as Ae } from "react";
import Pe, { createPortal as tt } from "react-dom";
import { usePopper as Oe } from "react-popper";
import { flip as Ct } from "@popperjs/core";
import Je from "deepmerge";
function rt(e) {
  var r, t, i = "";
  if (typeof e == "string" || typeof e == "number")
    i += e;
  else if (typeof e == "object")
    if (Array.isArray(e))
      for (r = 0; r < e.length; r++)
        e[r] && (t = rt(e[r])) && (i && (i += " "), i += t);
    else
      for (r in e)
        e[r] && (i && (i += " "), i += r);
  return i;
}
function U() {
  for (var e, r, t = 0, i = ""; t < arguments.length; )
    (e = arguments[t++]) && (r = rt(e)) && (i && (i += " "), i += r);
  return i;
}
const Et = {
  visible: "!visible",
  hidden: "hidden",
  collapsing: "h-0 transition-[height] overflow-hidden duration-[350ms] ease-[cubic-bezier(0.25,0.1,0.25,1.0)] motion-reduce:transition-none",
  collapsingHorizontal: "w-0 h-auto transition-[width] overflow-hidden duration-[350ms] ease-[cubic-bezier(0.25,0.1,0.25,1.0)] motion-reduce:transition-none",
  collapseStyles: "rounded-lg shadow-[0_2px_15px_-3px_rgba(0,0,0,0.07),0_10px_20px_-2px_rgba(0,0,0,0.04)] mt-3",
  scrollStyles: "max-h-24 overflow-y-auto max-w-[500px]"
}, we = (e, r, t = 150) => {
  const [i, l] = E(0), o = P(null), c = P(null), f = P(!1), s = (a) => {
    if (a !== null && !f.current) {
      f.current = !0;
      const { transitionDuration: x } = window.getComputedStyle(
        a
      ), d = Number(x.replace("s", "")) * 1e3;
      l(d);
      return;
    }
    if (!r)
      return;
    const u = r == null ? void 0 : r.split(" ");
    if (r != null && r.includes("duration")) {
      const x = u == null ? void 0 : u.find(
        (k) => k.includes("duration")
      ), d = Number(x == null ? void 0 : x.split("-")[1].replace(/\D/g, ""));
      l(d);
      return;
    } else
      r != null && r.includes("transition") && l(t);
  };
  C(() => {
    f.current || s(e);
  }, [e]);
  const n = (a) => {
    o.current !== null && clearTimeout(o.current), o.current = setTimeout(() => {
      a == null || a();
    }, 50);
  }, m = (a) => {
    f.current !== !1 && (c.current !== null && clearTimeout(c.current), c.current = setTimeout(() => {
      a == null || a();
    }, i));
  };
  return C(() => () => {
    c.current !== null && clearTimeout(c.current);
  }, []), {
    transitionDuration: i,
    onTransitionShow: n,
    onTransitionHide: m,
    getTransitionTime: s
  };
}, wr = ({
  className: e,
  children: r,
  show: t = !1,
  id: i,
  tag: l = "div",
  collapseRef: o,
  horizontal: c = !1,
  scroll: f = !1,
  onShow: s,
  onHide: n,
  theme: m,
  ...a
}) => {
  const [u, x] = E(!1), [d, k] = E(
    void 0
  ), [p, h] = E(!1), g = P(!0), b = {
    ...Et,
    ...m
  }, w = U(
    b.collapseStyles,
    b.visible,
    c ? `${b.collapsingHorizontal}` : `${b.collapsing}`,
    !p && !u && b.hidden,
    f && b.scrollStyles,
    e
  ), T = P(null), y = o ?? T, { onTransitionHide: O } = we(y.current), R = oe(() => {
    u && k(void 0);
  }, [u]);
  return C(() => {
    var $, F;
    d === void 0 && u && k(c ? ($ = y == null ? void 0 : y.current) == null ? void 0 : $.scrollWidth : (F = y == null ? void 0 : y.current) == null ? void 0 : F.scrollHeight);
  }, [d, u, y, c]), C(() => {
    if (g.current) {
      g.current = !1;
      return;
    }
    if (u !== t && (t ? s == null || s() : n == null || n(), x(t)), t) {
      h(!0);
      return;
    }
    O(() => {
      h(!1);
    });
  }, [t, s, n]), C(() => {
    var $, F;
    k(u ? c ? (($ = y == null ? void 0 : y.current) == null ? void 0 : $.scrollWidth) || 0 : ((F = y == null ? void 0 : y.current) == null ? void 0 : F.scrollHeight) || 0 : 0);
  }, [u, y, c]), C(() => (window.addEventListener("resize", R), () => {
    window.removeEventListener("resize", R);
  }), [R]), /* @__PURE__ */ v(
    l,
    {
      style: {
        ...c ? { width: d } : { height: d }
      },
      id: i,
      className: w,
      ...a,
      ref: y,
      children: r
    }
  );
}, It = ({ theme: e, style: r }) => {
  const [t, i] = E(!1), l = U(
    e.rippleWave,
    t ? e.rippleWaveActive : e.rippleWaveInactive
  );
  return C(() => {
    i(!0);
  }, []), /* @__PURE__ */ v("div", { style: r, className: l });
}, Nt = {
  ripple: "relative inline-block align-bottom",
  rippleOverflow: "absolute left-0 top-0 overflow-hidden w-full h-full pointer-events-none",
  rippleWave: "block rounded-[50%] pointer-events-none absolute touch-none transition-[transform,_opacity] ease-[cubic-bezier(0,0,0.15,1),_cubic-bezier(0,0,0.15,1)] z-[999] scale-0",
  rippleWaveActive: "scale-100 opacity-0",
  rippleWaveInactive: "scale-0 opacity-50",
  unbound: "overflow-visible"
}, Dt = (...e) => {
  const r = ue.useRef();
  return ue.useEffect(() => {
    e.forEach((t) => {
      t && (typeof t == "function" ? t(r.current) : t.current = r.current);
    });
  }, [e]), r;
}, kr = /* @__PURE__ */ ue.forwardRef(
  ({
    className: e,
    rippleTag: r = "div",
    rippleCentered: t,
    rippleDuration: i = 500,
    rippleUnbound: l,
    rippleRadius: o = 0,
    rippleColor: c = "dark",
    rippleColorDark: f = "",
    children: s,
    onMouseDown: n,
    theme: m,
    ...a
  }, u) => {
    const x = P(null), d = Dt(u, x), k = { ...Nt, ...m }, p = "rgba({{color}}, 0.2) 0, rgba({{color}}, 0.3) 40%, rgba({{color}}, 0.4) 50%, rgba({{color}}, 0.5) 60%, rgba({{color}}, 0) 70%", h = [0, 0, 0], g = [
      { name: "primary", gradientColor: "#3B71CA" },
      { name: "secondary", gradientColor: "#9FA6B2" },
      { name: "success", gradientColor: "#14A44D" },
      { name: "danger", gradientColor: "#DC4C64" },
      { name: "warning", gradientColor: "#E4A11B" },
      { name: "info", gradientColor: "#54B4D3" },
      { name: "light", gradientColor: "#fbfbfb" },
      { name: "dark", gradientColor: "#262626" }
    ], [b, w] = E([]), [T, y] = E([]), O = U(k.ripple, e), R = U(
      l ? k.unbound : k.rippleOverflow,
      T
    ), $ = () => {
      let N = c || "rgb(0,0,0)";
      (localStorage.theme === "dark" || !("theme" in localStorage) && window.matchMedia("(prefers-color-scheme: dark)").matches) && (N = f || c || "rgb(0,0,0)");
      const D = g.find(
        (z) => z.name === (N == null ? void 0 : N.toLowerCase())
      ), B = D ? F(D.gradientColor).join(",") : F(N).join(",");
      return `radial-gradient(circle, ${p.split("{{color}}").join(`${B}`)})`;
    }, F = (N) => {
      const D = (z) => (z.length < 7 && (z = `#${z[1]}${z[1]}${z[2]}${z[2]}${z[3]}${z[3]}`), [
        parseInt(z.substr(1, 2), 16),
        parseInt(z.substr(3, 2), 16),
        parseInt(z.substr(5, 2), 16)
      ]), B = (z) => {
        const X = document.body.appendChild(
          document.createElement("fictum")
        ), G = "rgb(1, 2, 3)";
        return X.style.color = G, X.style.color !== G || (X.style.color = z, X.style.color === G || X.style.color === "") ? h : (z = getComputedStyle(X).color, document.body.removeChild(X), z);
      }, W = (z) => (z = z.match(/[.\d]+/g).map((X) => +Number(X)), z.length = 3, z);
      return N.toLowerCase() === "transparent" ? h : N[0] === "#" ? D(N) : (N.indexOf("rgb") === -1 && (N = B(N)), N.indexOf("rgb") === 0 ? W(N) : h);
    }, K = (N) => {
      const { offsetX: D, offsetY: B, height: W, width: z } = N, X = B <= W / 2, G = D <= z / 2, J = (le, ce) => Math.sqrt(le ** 2 + ce ** 2), q = B === W / 2 && D === z / 2, te = {
        first: X === !0 && G === !1,
        second: X === !0 && G === !0,
        third: X === !1 && G === !0,
        fourth: X === !1 && G === !1
      }, Q = {
        topLeft: J(D, B),
        topRight: J(z - D, B),
        bottomLeft: J(D, W - B),
        bottomRight: J(z - D, W - B)
      };
      let I = 0;
      return q || te.fourth ? I = Q.topLeft : te.third ? I = Q.topRight : te.second ? I = Q.bottomRight : te.first && (I = Q.bottomLeft), I * 2;
    }, S = () => !s || !ue.isValidElement(s) || Array.isArray(s) || !s.props.className ? [] : s.props.className.split(" ").filter((D) => D.includes("rounded")), j = (N) => {
      var I;
      const D = (I = d.current) == null ? void 0 : I.getBoundingClientRect(), B = N.clientX - D.left, W = N.clientY - D.top, z = D.height, X = D.width, G = {
        offsetX: t ? z / 2 : B,
        offsetY: t ? X / 2 : W,
        height: z,
        width: X
      }, J = {
        delay: i && i * 0.5,
        duration: i && i - i * 0.5
      }, q = K(G), te = o || q / 2, Q = {
        left: t ? `${X / 2 - te}px` : `${B - te}px`,
        top: t ? `${z / 2 - te}px` : `${W - te}px`,
        height: o ? `${o * 2}px` : `${q}px`,
        width: o ? `${o * 2}px` : `${q}px`,
        transitionDelay: `0s, ${J.delay}ms`,
        transitionDuration: `${i}ms, ${J.duration}ms`
      };
      return y(S()), { ...Q, backgroundImage: `${$()}` };
    }, M = (N) => {
      const D = j(N), B = b.concat(D);
      w(B), n && n(N);
    };
    return C(() => {
      const N = setTimeout(() => {
        b.length > 0 && w(b.splice(1, b.length - 1));
      }, i);
      return () => {
        clearTimeout(N);
      };
    }, [i, b]), /* @__PURE__ */ ne(
      r,
      {
        className: O,
        onMouseDown: (N) => M(N),
        ref: d,
        ...a,
        children: [
          s,
          /* @__PURE__ */ v("div", { className: R, children: b.map((N, D) => /* @__PURE__ */ v(It, { theme: k, style: N }, D)) })
        ]
      }
    );
  }
), We = je({
  isOpenModal: !1,
  setTransitionDuration: null,
  scrollable: !1
}), Rt = {
  show: "transform-none",
  static: "!scale-[1.02]",
  staticProperties: "transition-scale duration-300 ease-in-out",
  wrapper: "fixed left-0 top-0 z-[1055] h-full w-full overflow-y-auto overflow-x-hidden outline-none"
}, At = {
  wrapper: "transition-all duration-300 ease-in-out fixed top-0 left-0 z-[1040] bg-black w-screen h-screen"
}, Pt = ({
  className: e,
  appendToBody: r = !1,
  show: t,
  animate: i = !0,
  theme: l,
  ...o
}) => {
  const c = { ...At, ...l }, [f, s] = E(t), [n, m] = E(!1), a = P(0), u = P(null), x = P(null), d = U(
    c.wrapper,
    f ? "block" : "hidden",
    n ? "opacity-50" : "opacity-0"
  );
  C(() => {
    if (u.current) {
      const { transitionDuration: h } = window.getComputedStyle(
        u.current
      ), g = Number(h.replace("s", "")) * 1e3;
      a.current = g;
    }
  }, []), C(() => (t ? (s(t), x.current = setTimeout(
    () => {
      m(t);
    },
    i ? 50 : 0
  )) : (m(t), x.current = setTimeout(
    () => {
      s(t);
    },
    i ? a.current : 0
  )), () => {
    x.current && clearInterval(x.current);
  }), [t]);
  const k = /* @__PURE__ */ v("div", { className: d, ...o, ref: u }), p = /* @__PURE__ */ v(be, { children: Pe.createPortal(k, document.body) });
  return /* @__PURE__ */ v(be, { children: r ? p : k });
}, Ot = () => {
  const e = document.body, r = () => {
    const n = l();
    i(), c(), e.style.paddingRight = `${n}px`;
  }, t = () => {
    f(), s();
  }, i = () => {
    o(), e.style.overflow = "hidden";
  }, l = () => {
    const n = document.documentElement.clientWidth;
    return Math.abs(window.innerWidth - n);
  }, o = () => {
    e.hasAttribute("data-initial-overflow") || (e.dataset.initialOverflow = e.style.overflow);
  }, c = () => {
    e.dataset.initialPadding = e.style.paddingRight;
  }, f = () => {
    e.style.overflow = e.dataset.initialOverflow || "", e.removeAttribute("data-initial-overflow");
  }, s = () => {
    e.style.paddingRight = e.dataset.initialPadding || "", e.removeAttribute("data-initial-padding");
  };
  return { scrollbarHide: r, scrollbarReset: t, getWidth: l };
}, Wt = () => {
  let e = null, r = null, t = null;
  function i(n) {
    return e = n, l(), window.addEventListener("keydown", f), !0;
  }
  function l() {
    const n = Array.from(
      e == null ? void 0 : e.querySelectorAll(
        'button, a, input, select, textarea, [tabindex]:not([tabindex="-1"])'
      )
    ).filter((m) => {
      const a = m instanceof HTMLAnchorElement ? !0 : !m.disabled;
      return !m.classList.contains("ps__thumb-x") && !m.classList.contains("ps__thumb-y") && a;
    });
    n.length !== 0 && (r = n[0], t = n[n.length - 1], t == null || t.addEventListener(
      "keydown",
      (m) => o(m)
    ));
  }
  function o(n) {
    n.key === "Tab" && (n.preventDefault(), c());
  }
  function c() {
    r && (r == null || r.focus());
  }
  function f(n, m = !1) {
    n.key === "Tab" && (n.preventDefault(), c()), !m && window.removeEventListener("keydown", f);
  }
  function s() {
    t == null || t.removeEventListener(
      "keydown",
      (n) => o(n)
    );
  }
  return {
    initFocusTrap: i,
    removeFocusTrap: s
  };
}, yr = ({
  show: e = !1,
  setShow: r,
  appendToBody: t = !1,
  backdrop: i = !0,
  staticBackdrop: l,
  closeOnEsc: o = !0,
  scrollable: c = !1,
  leaveHiddenModal: f = !0,
  modalRef: s,
  children: n,
  className: m,
  tag: a = "div",
  theme: u,
  onHide: x,
  onShow: d,
  onHidePrevented: k,
  ...p
}) => {
  const h = { ...Rt, ...u }, { scrollbarHide: g, scrollbarReset: b } = Ot(), { initFocusTrap: w, removeFocusTrap: T } = Wt(), [y, O] = E(e || !1), [R, $] = E(0), [F, K] = E(!1), S = P(null), j = s || S, M = U(
    h.wrapper,
    m,
    l && h.staticProperties,
    F && h.static,
    y ? h.show : "hidden"
  ), { onTransitionHide: N } = we(j.current), D = () => {
    K(!0), N(() => {
      K(!1);
    });
  }, B = (q) => {
    if (!(q.target !== j.current || !i)) {
      if (l) {
        D(), k == null || k();
        return;
      }
      r(!1);
    }
  }, W = oe(
    (q) => {
      o && y && q.key === "Escape" && (l ? (D(), k == null || k()) : r(!1));
    },
    [y]
  ), z = () => {
    O(!0), d == null || d(), w(j.current);
  }, X = () => {
    O((q) => (q && (x == null || x()), !1)), T();
  };
  C(() => {
    e ? z() : setTimeout(() => {
      X();
    }, R);
  }, [e]), C(() => {
    y ? g() : b();
  }, [y]), C(() => (window.addEventListener("keydown", W), () => {
    window.removeEventListener("keydown", W);
  }), [W]);
  const G = /* @__PURE__ */ ne(
    We.Provider,
    {
      value: { isOpenModal: e, setTransitionDuration: $, scrollable: c },
      children: [
        (f || e) && /* @__PURE__ */ v(
          a,
          {
            ref: j,
            className: M,
            onClick: B,
            ...y && { "aria-modal": "true" },
            ...!y && { "aria-hidden": "true" },
            ...p,
            children: n
          }
        ),
        i && (f || e) && /* @__PURE__ */ v(Pt, { show: y, appendToBody: t })
      ]
    }
  ), J = /* @__PURE__ */ v(be, { children: Pe.createPortal(G, document.body) });
  return /* @__PURE__ */ v(be, { children: t ? J : G });
}, St = {
  centered: "h-[calc(100vh-3.5rem)] flex items-center justify-center",
  fullscreen: "!h-full w-full !m-0",
  hidden: "translate-y-[-50px] opacity-0",
  scrollable: "h-[calc(100vh-3.5rem)] overflow-hidden",
  show: "translate-y-0 opacity-100",
  sizeDefault: "min-[576px]:max-w-[500px]",
  wrapper: "pointer-events-none transition-all duration-300 ease-in-out min-[576px]:mx-auto min-[576px]:mt-7",
  wrapperPositionDefault: "relative w-auto",
  "bottom-left": "w-full absolute bottom-7 left-7",
  "bottom-right": "w-full absolute bottom-7 right-7",
  "top-left": "w-full absolute left-7",
  "top-right": "w-full absolute right-7",
  sm: "min-[576px]:max-w-[300px]",
  lg: "min-[992px]:max-w-[800px]",
  xl: "min-[992px]:max-w-[800px] min-[1200px]:max-w-[1140px]"
}, Tr = ({
  className: e,
  centered: r,
  position: t,
  children: i,
  size: l,
  theme: o,
  tag: c = "div",
  ...f
}) => {
  const s = { ...St, ...o }, { isOpenModal: n, setTransitionDuration: m, scrollable: a } = me(We), [u, x] = E(!1), d = P(null), k = U(
    s.wrapper,
    u ? s.show : s.hidden,
    a && s.scrollable,
    r && s.centered,
    t ? s[t] : s.wrapperPositionDefault,
    l && s[l] ? s[l] : s.sizeDefault,
    e
  ), { transitionDuration: p } = we(d.current);
  return C(() => {
    m(p);
  }, [p]), C(() => {
    let h;
    return n ? h = setTimeout(() => {
      x(!0);
    }, 50) : x(!1), () => {
      clearTimeout(h);
    };
  }, [n]), /* @__PURE__ */ v(c, { className: k, ...f, ref: d, children: i });
}, Bt = {
  wrapper: "min-[576px]:shadow-[0_0.5rem_1rem_rgba(#000, 0.15)] pointer-events-auto relative flex w-full flex-col rounded-md border-none bg-white bg-clip-padding text-current shadow-lg outline-none dark:bg-neutral-600",
  scrollable: "max-h-full"
}, Lr = ue.forwardRef(
  ({ className: e, children: r, theme: t, tag: i = "div", ...l }, o) => {
    const c = { ...Bt, ...t }, { scrollable: f } = me(We), s = U(
      c.wrapper,
      f && c.scrollable,
      e
    );
    return /* @__PURE__ */ v(i, { className: s, ...l, ref: o, children: r });
  }
), Mt = {
  wrapper: "flex flex-shrink-0 items-center justify-between rounded-t-md border-b-2 border-neutral-100 border-opacity-100 p-4 dark:border-opacity-50"
}, _r = ue.forwardRef(
  ({ className: e, children: r, theme: t, tag: i = "div", ...l }, o) => {
    const c = { ...Mt, ...t }, f = U(c.wrapper, e);
    return /* @__PURE__ */ v(i, { className: f, ...l, ref: o, children: r });
  }
), zt = {
  scrollable: "overflow-y-auto",
  wrapper: "relative flex-auto p-4"
}, Cr = ue.forwardRef(
  ({ className: e, children: r, theme: t, tag: i = "div", ...l }, o) => {
    const c = { ...zt, ...t }, { scrollable: f } = me(We), s = U(
      c.wrapper,
      f && c.scrollable,
      e
    );
    return /* @__PURE__ */ v(i, { className: s, ...l, ref: o, children: r });
  }
), Ft = {
  wrapper: "flex flex-shrink-0 flex-wrap items-center justify-end rounded-b-md border-t-2 border-neutral-100 border-opacity-100 p-4 dark:border-opacity-50"
}, Er = ue.forwardRef(
  ({ className: e, children: r, theme: t, tag: i = "div", ...l }, o) => {
    const c = { ...Ft, ...t }, f = U(c.wrapper, e);
    return /* @__PURE__ */ v(i, { className: f, ...l, ref: o, children: r });
  }
), $t = {
  wrapper: "relative",
  input: "peer block min-h-[auto] w-full rounded border-0 bg-transparent outline-none transition-all duration-200 ease-linear focus:placeholder:opacity-100 peer-focus:text-primary motion-reduce:transition-none` placeholder:opacity-0 disabled:bg-neutral-100 read-only:bg-neutral-100 dark:disabled:bg-neutral-700 dark:read-only:bg-neutral-700 dark:placeholder:text-neutral-200 dark:peer-focus:text-primary",
  inputDefault: "text-neutral-800 dark:text-neutral-200",
  inputWhite: "text-white",
  activeInput: "placeholder:opacity-100",
  label: "pointer-events-none absolute left-3 top-0 mb-0 max-w-[90%] origin-[0_0] truncate transition-all duration-200 ease-out peer-focus:scale-[0.8] motion-reduce:transition-none",
  labelDefault: "text-neutral-500 dark:text-neutral-200 peer-focus:text-primary dark:peer-focus:text-primary",
  labelWhite: "text-white",
  activeLabel: "scale-[0.8]",
  notch: "group flex absolute left-0 top-0 w-full max-w-full h-full text-left pointer-events-none",
  notchLeading: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none left-0 top-0 h-full w-2 border-r-0 rounded-l-[0.25rem]",
  activeNotchLeading: "border-r-0",
  focusedNotchLeading: "border-r-0",
  notchLeadingDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchLeadingDefault: "shadow-[-1px_0_0_#3b71ca,_0_1px_0_0_#3b71ca,_0_-1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchLeadingWhite: "border-neutral-200",
  focusedNotchLeadingWhite: "shadow-[-1px_0_0_#ffffff,_0_1px_0_0_#ffffff,_0_-1px_0_0_#ffffff] border-white",
  notchMiddle: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none grow-0 shrink-0 basis-auto w-auto max-w-[calc(100%-1rem)] h-full border-r-0 border-l-0",
  activeNotchMiddle: "border-x-0 border-t border-solid border-t-transparent dark:border-t-transparent",
  focusedNotchMiddle: "border-x-0 border-t border-solid border-t-transparent dark:border-t-transparent",
  notchMiddleDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchMiddleDefault: "shadow-[0_1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchMiddleWhite: "border-neutral-200",
  focusedNotchMiddleWhite: "shadow-[0_1px_0_0_#ffffff] border-white",
  notchTrailing: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none grow h-full border-l-0 rounded-r-[0.25rem]",
  activeNotchTrailing: "border-l-0",
  focusedNotchTrailing: "border-l-0",
  notchTrailingDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchTrailingDefault: "shadow-[1px_0_0_#3b71ca,_0_-1px_0_0_#3b71ca,_0_1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchTrailingWhite: "border-neutral-200",
  focusedNotchTrailingWhite: "shadow-[1px_0_0_#ffffff,_0_-1px_0_0_#ffffff,_0_1px_0_0_#ffffff] border-white",
  counter: "text-right leading-[1.6]",
  inputSizeLg: "px-3 py-[0.32rem] leading-[2.15]",
  inputSizeBase: "px-3 py-[0.32rem] leading-[1.6]",
  inputSizeSm: "px-3 py-[0.33rem] text-xs leading-[1.5]",
  labelSizeLg: "pt-[0.36rem] leading-[2.15] peer-focus:-translate-y-[1.15rem]",
  activeLabelSizeLg: "-translate-y-[1.15rem]",
  labelSizeBase: "pt-[0.30rem] leading-[1.6] peer-focus:-translate-y-[0.9rem]",
  activeLabelSizeBase: "-translate-y-[0.9rem]",
  labelSizeSm: "pt-[0.36rem] text-xs leading-[1.5] peer-focus:-translate-y-[0.75rem]",
  activeLabelSizeSm: "-translate-y-[0.75rem]"
}, nt = (e, r, t, i, l, o, c, f, s, n, m, a) => {
  var N, D;
  const [u, x] = E(t || i), [d, k] = E(0), [p, h] = E(!1), [g, b] = E(!1), w = P(null), T = r || w, y = U(
    s.input,
    p && s.activeInput,
    n === "lg" ? s.inputSizeLg : n === "base" ? s.inputSizeBase : n === "sm" ? s.inputSizeSm : s.inputSizeBase,
    a ? s.inputWhite : s.inputDefault,
    m
  ), O = U(
    s.label,
    p && s.activeLabel,
    p && (n === "lg" ? s.activeLabelSizeLg : n === "base" ? s.activeLabelSizeBase : n === "sm" ? s.activeLabelSizeSm : s.activeLabelSizeBase),
    n === "lg" ? s.labelSizeLg : n === "base" ? s.labelSizeBase : n === "sm" ? s.labelSizeSm : s.labelSizeBase,
    a ? s.labelWhite : s.labelDefault
  ), R = U(
    s.notchLeading,
    a ? s.notchLeadingWhite : s.notchLeadingDefault,
    p && s.activeNotchLeading,
    g && s.focusedNotchLeading,
    g && (a ? s.focusedNotchLeadingWhite : s.focusedNotchLeadingDefault)
  ), $ = U(
    s.notchMiddle,
    a ? s.notchMiddleWhite : s.notchMiddleDefault,
    p && s.activeNotchMiddle,
    g && s.focusedNotchMiddle,
    g && (a ? s.focusedNotchMiddleWhite : s.focusedNotchMiddleDefault)
  ), F = U(
    s.notchTrailing,
    a ? s.notchTrailingWhite : s.notchTrailingDefault,
    p && s.activeNotchTrailing,
    g && s.focusedNotchTrailing,
    g && (a ? s.focusedNotchTrailingWhite : s.focusedNotchTrailingDefault)
  );
  C(() => {
    if (!e.current)
      return;
    const { value: B } = e.current;
    B != "" ? h(!0) : h(!1);
  }, [(N = e.current) == null ? void 0 : N.value]), C(() => {
    t !== void 0 && (t != "" ? h(!0) : h(!1));
  }, [t]), C(() => {
    i !== void 0 && (i != "" ? h(!0) : h(!1));
  }, [i]);
  const K = oe(() => {
    var B;
    (B = T.current) != null && B.clientWidth && k(T.current.clientWidth * 0.8 + 8);
  }, [T]);
  C(() => {
    K();
  }, [(D = T.current) == null ? void 0 : D.clientWidth, K]);
  const S = (B) => {
    c ? j(B) : x(B.target.value), o == null || o(B);
  }, j = (B) => {
    const W = B.target.value;
    f === void 0 || f <= 0 || W.length <= f && x(W);
  }, M = oe(
    (B) => {
      e.current && (u !== void 0 && u != "" || t !== void 0 && t != "" || e.current.value != "" ? h(!0) : h(!1), l && (l == null || l(B)));
    },
    [u, t, l]
  );
  return {
    labelReference: T,
    labelWidth: d,
    newValue: u,
    setWidth: K,
    setFocus: b,
    handleChange: S,
    handleBlur: M,
    inputClasses: y,
    labelClasses: O,
    notchLeadingClasses: R,
    notchMiddleClasses: $,
    notchTrailingClasses: F
  };
}, jt = /* @__PURE__ */ ue.forwardRef(
  ({
    className: e,
    size: r = "base",
    value: t,
    defaultValue: i,
    id: l,
    wrapperTag: o = "div",
    label: c,
    onChange: f,
    children: s,
    labelRef: n,
    labelID: m,
    type: a,
    onBlur: u,
    readonly: x = !1,
    theme: d,
    formWhite: k = !1,
    counter: p = !1,
    maxLength: h,
    ...g
  }, b) => {
    const w = P(null);
    Tt(b, () => w.current);
    const T = { ...$t, ...d }, {
      labelReference: y,
      labelWidth: O,
      newValue: R,
      setWidth: $,
      setFocus: F,
      handleChange: K,
      handleBlur: S,
      inputClasses: j,
      labelClasses: M,
      notchLeadingClasses: N,
      notchMiddleClasses: D,
      notchTrailingClasses: B
    } = nt(
      w,
      n,
      t,
      i,
      u,
      f,
      p,
      h,
      T,
      r,
      e,
      k
    );
    return /* @__PURE__ */ ne(o, { children: [
      /* @__PURE__ */ ne(o, { className: T.wrapper, children: [
        /* @__PURE__ */ v(
          "input",
          {
            type: a,
            readOnly: x,
            className: j,
            onBlur: (W) => {
              S(W), F(!1);
            },
            onChange: K,
            onFocus: () => {
              F(!0);
            },
            value: t,
            defaultValue: i,
            id: l,
            ref: w,
            maxLength: h,
            ...g
          }
        ),
        c && /* @__PURE__ */ v(
          "label",
          {
            id: m,
            className: M,
            htmlFor: l,
            ref: y,
            children: c
          }
        ),
        /* @__PURE__ */ ne("div", { className: T.notch, children: [
          /* @__PURE__ */ v("div", { className: N }),
          /* @__PURE__ */ v(
            "div",
            {
              className: D,
              style: { width: O }
            }
          ),
          /* @__PURE__ */ v("div", { className: B })
        ] }),
        s
      ] }),
      p && h !== void 0 && h > 0 && /* @__PURE__ */ v("div", { className: T.counter, children: /* @__PURE__ */ ne("span", { children: [
        (R == null ? void 0 : R.toString().length) || 0,
        " / ",
        h
      ] }) })
    ] });
  }
), Xt = {
  defaultTabs: "mb-5 flex list-none flex-row flex-wrap border-b-0 pl-0",
  verticalTabs: "mr-4 flex list-none flex-col flex-wrap pl-0",
  pillsTabs: "mb-5 flex list-none flex-col flex-wrap pl-0 md:flex-row"
}, ot = ue.createContext({}), Ir = /* @__PURE__ */ ue.forwardRef(
  ({
    className: e,
    children: r,
    theme: t,
    fill: i = !1,
    justify: l = !1,
    vertical: o = !1,
    pills: c = !1,
    ...f
  }, s) => {
    const n = {
      ...Xt,
      ...t
    }, m = U(
      c ? o ? n.verticalTabs : n.pillsTabs : o ? n.verticalTabs : n.defaultTabs,
      e
    );
    return /* @__PURE__ */ v(
      ot.Provider,
      {
        value: {
          fill: i,
          justify: l,
          vertical: o,
          pills: c
        },
        children: /* @__PURE__ */ v("ul", { className: m, ref: s, ...f, children: r })
      }
    );
  }
), qt = {
  fillTabsItem: "flex-auto text-center",
  justifyTabsItem: "flex-grow basis-0 text-center",
  verticalTabsItem: "flex-grow text-center",
  disabledTabsItem: "disabled pointer-events-none",
  tabsLink: "mt-2 block cursor-pointer border-x-0 border-b-2 border-t-0 px-7 pb-3.5 pt-4 text-xs font-medium uppercase leading-tight hover:isolate hover:border-x-0 hover:bg-neutral-100 dark:hover:bg-transparent focus:isolate",
  pillsLink: "mt-2 block cursor-pointer rounded bg-neutral-100 px-7 pb-3.5 pt-4 text-xs font-medium uppercase leading-tight text-neutral-500 dark:bg-neutral-700 dark:text-white md:mr-4",
  inactiveTabsLink: "border-transparent text-neutral-500 focus:border-transparent dark:text-neutral-400",
  inactivePillsLink: "bg-neutral-100 dark:bg-neutral-700 dark:text-white md:mr-4",
  disabledTabsLink: "!text-neutral-400 dark:!text-neutral-600",
  disabledPillsLink: "!bg-neutral-200 !text-neutral-400 dark:!text-neutral-500 dark:!bg-neutral-600",
  activePrimaryPillsLink: "!bg-primary-100 !text-primary-700 dark:text-primary-700 ",
  activeSecondaryPillsLink: "!bg-secondary-200 !text-secondary-900 dark:text-secondary-900",
  activeSuccessPillsLink: "!bg-success-100 !text-success-700 dark:text-success-700",
  activeDangerPillsLink: "!bg-danger-100 !text-danger-700 dark:text-danger-700",
  activeWarningPillsLink: "!bg-warning-100 !text-warning-800 dark:text-warning-800",
  activeInfoPillsLink: "!bg-info-100 !text-info-800 dark:text-info-800",
  activeLightPillsLink: "!bg-neutral-50 !text-neutral-600 dark:text-neutral-600",
  activeDarkPillsLink: "!bg-neutral-800 !text-neutral-50 dark:!bg-neutral-900 dark:text-neutral-50",
  activePrimaryTabsLink: "text-primary border-primary dark:border-primary-400 dark:text-primary-400",
  activeSecondaryTabsLink: "text-secondary border-secondary dark:text-secondary",
  activeSuccessTabsLink: "border-success text-success dark:text-success",
  activeDangerTabsLink: "border-danger text-danger dark:text-danger",
  activeWarningTabsLink: "border-warning text-warning dark:text-warning",
  activeInfoTabsLink: "border-info text-info dark:text-info",
  activeLightTabsLink: "border-neutral-50 text-neutral-50 dark:text-neutral-50",
  activeDarkTabsLink: "border-neutral-800 text-neutral-800 dark:border-neutral-600 dark:text-neutral-600"
}, Nr = /* @__PURE__ */ ue.forwardRef(
  ({
    className: e,
    wrapperClass: r,
    active: t = !1,
    disabled: i = !1,
    color: l = "primary",
    children: o,
    theme: c,
    tag: f = "a",
    ...s
  }, n) => {
    const { fill: m, justify: a, vertical: u, pills: x } = me(ot), d = {
      ...qt,
      ...c
    }, k = U(
      m && d.fillTabsItem,
      a && d.justifyTabsItem,
      u && d.verticalTabsItem,
      i && d.disabledTabsItem,
      r
    ), p = {
      primary: {
        tabs: d.activePrimaryTabsLink,
        pills: d.activePrimaryPillsLink
      },
      secondary: {
        tabs: d.activeSecondaryTabsLink,
        pills: d.activeSecondaryPillsLink
      },
      success: {
        tabs: d.activeSuccessTabsLink,
        pills: d.activeSuccessPillsLink
      },
      danger: {
        tabs: d.activeDangerTabsLink,
        pills: d.activeDangerPillsLink
      },
      warning: {
        tabs: d.activeWarningTabsLink,
        pills: d.activeWarningPillsLink
      },
      info: {
        tabs: d.activeInfoTabsLink,
        pills: d.activeInfoPillsLink
      },
      light: {
        tabs: d.activeLightTabsLink,
        pills: d.activeLightPillsLink
      },
      dark: {
        tabs: d.activeDarkTabsLink,
        pills: d.activeDarkPillsLink
      }
    }, h = U(
      x ? d.pillsLink : d.tabsLink,
      i ? x ? d.disabledPillsLink : d.disabledTabsLink : "",
      x && !i ? t ? p[l].pills : d.inactivePillsLink : t ? p[l].tabs : d.inactiveTabsLink,
      e
    );
    return /* @__PURE__ */ v("li", { className: k, role: "presentation", ref: n, ...s, children: /* @__PURE__ */ v(f, { className: h, ref: n, role: "tab", ...s, children: o }) });
  }
), Yt = {
  tabsContent: "my-2"
}, Dr = /* @__PURE__ */ ue.forwardRef(
  ({ className: e, tag: r = "div", children: t, theme: i, ...l }, o) => {
    const c = {
      ...Yt,
      ...i
    }, f = U(c.tabsContent, e);
    return /* @__PURE__ */ v(r, { className: f, ref: o, ...l, children: t });
  }
), Kt = {
  tabsPane: "transition-opacity duration-150 ease-linear",
  isShown: "block",
  isHidden: "hidden",
  activeTabsPane: "opacity-100",
  inactiveTabsPane: "opacity-0"
}, Gt = (...e) => {
  const r = ue.useRef();
  return ue.useEffect(() => {
    e.forEach((t) => {
      t && (typeof t == "function" ? t(r.current) : t.current = r.current);
    });
  }, [e]), r;
}, Rr = /* @__PURE__ */ ue.forwardRef(
  ({
    className: e,
    tag: r = "div",
    show: t = !1,
    theme: i,
    onShow: l,
    onShown: o,
    onHide: c,
    onHidden: f,
    children: s,
    ...n
  }, m) => {
    const [a, u] = E(!1), x = P(null), d = Gt(m, x), k = P(0), p = {
      ...Kt,
      ...i
    }, h = U(
      p.tabsPane,
      t ? p.isShown : p.isHidden,
      a ? p.activeTabsPane : p.inactiveTabsPane,
      e
    );
    return C(() => {
      if (x.current) {
        const { transitionDuration: g } = window.getComputedStyle(
          x.current
        ), b = Number(g.replace("s", "")) * 1e3;
        k.current = b;
      }
    }, []), C(() => {
      let g;
      return t ? (l == null || l(), g = setTimeout(() => {
        u(!0), o == null || o();
      }, 100)) : (c == null || c(), u(!1), g = setTimeout(() => {
        f == null || f();
      }, k.current)), () => {
        clearTimeout(g);
      };
    }, [t]), /* @__PURE__ */ v(r, { className: h, role: "tabpanel", ref: d, ...n, children: s });
  }
), Ar = ({
  tag: e = "div",
  className: r,
  children: t,
  animation: i,
  reset: l,
  start: o = "onClick",
  repeat: c = !1,
  delay: f,
  reverse: s,
  interval: n,
  toggle: m = null,
  offset: a = 0,
  repeatOnScroll: u,
  showOnLoad: x,
  animationRef: d,
  beginHidden: k,
  onStart: p,
  onEnd: h,
  onShow: g,
  onHide: b,
  ...w
}) => {
  const [T, y] = E(!1), [O, R] = E(!1), $ = P(!0), F = P(!1), K = P(null), S = P(null), j = P(null), M = P(null), N = P(null), D = P(
    null
  ), B = U(T && `animate-${i}`, r), W = d || K, z = (I, le, ce) => {
    I.addEventListener(le, ce);
  }, X = (I, le, ce) => {
    I.removeEventListener(le, ce);
  }, G = {
    onHover: "mouseover",
    onClick: "click",
    onScroll: "scroll"
  }, J = oe(() => {
    F.current && o !== "manually" || (k && R(!0), F.current = !0, o === "onScroll" ? g == null || g() : p == null || p(), f ? (S.current !== null && clearTimeout(S.current), S.current = setTimeout(() => {
      y((I) => !I);
    }, f)) : y((I) => !I));
  }, [o, f, k]), q = oe(() => {
    if (T && o !== "manually" && !u && (!l || n)) {
      const I = W.current;
      switch (o) {
        case "onHover":
        case "onClick":
          X(I, G[o], J);
          break;
        case "onScroll":
          X(window, G[o], Q);
          break;
      }
      (f || !s && !n) && W.current.removeEventListener(
        "animationend",
        te
      ), s && !l && W.current.removeEventListener(
        "animationend",
        te
      );
    }
  }, [
    T,
    o,
    l,
    s,
    n,
    u,
    f,
    W
  ]), te = oe(() => {
    F.current && (y((I) => !I), o === "onScroll" ? b == null || b() : h == null || h(), o !== "onScroll" && (F.current = !1), n && (j.current !== null && clearTimeout(j.current), j.current = setInterval(() => {
      y((I) => !I), p == null || p();
    }, n)), q());
  }, [o, n, q]), Q = oe(() => {
    if (!W.current)
      return;
    const I = W.current, ce = I.getBoundingClientRect().top + document.body.scrollTop + a, Ce = I.offsetHeight, ye = window.innerHeight, ve = ce <= ye && ce + Ce >= 0;
    ve && !O ? (f ? (M.current !== null && clearTimeout(M.current), M.current = setTimeout(() => {
      R(!0);
    }, f)) : R(!0), J()) : !ve && u && (R(!1), F.current = !1);
  }, [a, u, W, O, f]);
  return C(() => {
    const I = W.current;
    switch (o) {
      case "onHover":
      case "onClick":
        z(I, G[o], J);
        break;
      case "onScroll":
        z(window, G[o], Q);
        break;
      case "onLoad":
        N.current !== null && clearTimeout(N.current), f ? N.current = setTimeout(() => {
          y(!0);
        }, f) : y(!0);
        break;
    }
    return () => {
      switch (o) {
        case "onHover":
        case "onClick":
          X(I, G[o], J);
          break;
        case "onScroll":
          x && (D.current !== null && clearTimeout(D.current), f ? D.current = setTimeout(() => {
            R(!0);
          }, f) : R(!0), J()), X(window, G[o], Q);
          break;
        case "onLoad":
          y(!1), p == null || p(), F.current = !0;
          break;
      }
    };
  }, [W, o, f, x]), C(() => {
    const I = W.current;
    return I.addEventListener("animationend", te), () => {
      I.removeEventListener("animationend", te);
    };
  }, [W, te]), C(() => {
    if ($.current) {
      $.current = !1;
      return;
    }
    m !== null && o === "manually" && (m ? J() : te());
  }, [o, m]), C(() => () => clearTimeout(j.current), []), /* @__PURE__ */ v(
    e,
    {
      className: B,
      ref: W,
      style: {
        animationIterationCount: n ? null : c === !0 ? "infinite" : s ? "2" : c,
        animationDirection: s ? "alternate" : null,
        visibility: o === "onScroll" || k ? O ? "visible" : "hidden" : null
      },
      ...w,
      children: t
    }
  );
}, Xe = ue.createContext({}), Pr = ({
  children: e,
  tag: r = "div",
  isOpen: t = !1,
  enabled: i = !0,
  trigger: l = "click",
  onShow: o,
  onHide: c,
  onShown: f,
  onHidden: s,
  onMouseEnter: n,
  onMouseLeave: m,
  ...a
}) => {
  const [u, x] = E(t ?? !1), [d, k] = E(!1), p = P(null), h = oe(
    (g, b) => {
      if (i)
        if (b === "mouseenter" && (n == null || n(g)), b === "mouseleave" && (m == null || m(g)), b === "mouseleave" && !l.includes("click") || (b === "mouseenter" || b === "mouseleave") && l !== "click" && l !== "focus") {
          if (b === "mouseenter" && d || b === "mouseleave" && !u || l.includes("click") && l.includes("focus") && !l.includes("hover"))
            return;
          b === "mouseenter" ? (!d && (o == null || o(g)), !g.defaultPrevented && x(!0)) : (!d && (c == null || c(g)), !g.defaultPrevented && x(!1));
        } else
          b === "mousedown" && (g.target === p.current ? l === "click" ? (!u && (o == null || o(g)), u && (c == null || c(g)), x((w) => !w)) : l.includes("focus") ? (!d && !u && (o == null || o(g)), k(!0)) : l.includes("click") && (!d && !u && (o == null || o(g)), d && (c == null || c(g)), k((w) => !w), d && x(!1)) : l.includes("focus") && (d && (c == null || c(g)), k(!1)));
    },
    [i, l, u, d]
  );
  return C(() => {
    if (!i)
      return;
    const g = (b) => {
      h(b, "mousedown");
    };
    return document.addEventListener("mousedown", g), () => {
      document.removeEventListener("mousedown", g);
    };
  }, [i, h]), C(() => {
    t || x(!1);
  }, [t]), /* @__PURE__ */ v(
    Xe.Provider,
    {
      value: {
        referenceElement: p,
        isOpenState: u,
        isFocused: d,
        enabled: i,
        trigger: l,
        onShown: f,
        onHidden: s,
        handleMouseAndClick: h
      },
      children: /* @__PURE__ */ v(r, { ...a, children: e })
    }
  );
}, Or = ({
  children: e,
  tag: r = "button",
  ...t
}) => {
  const { handleMouseAndClick: i, referenceElement: l } = me(Xe);
  return /* @__PURE__ */ v(
    r,
    {
      ref: l,
      onMouseEnter: (o) => i(o, "mouseenter"),
      onMouseLeave: (o) => i(o, "mouseleave"),
      ...t,
      children: e
    }
  );
}, Ut = {
  popoverContent: "z-[1070] p-1 block max-w-[267px] rounded break-words text-sm not-italic font-normal text-left no-underline underline-offset-auto normal-case leading-6 tracking-normal break-normal whitespace-normal dark:text-white data-[popper-reference-hidden='true']:hidden",
  fade: "transition-opacity ease-linear motion-reduce:transition-none"
}, Wr = ({
  className: e,
  children: r,
  theme: t,
  popperTag: i = "div",
  container: l = !1,
  placement: o = "right",
  popperConfig: c,
  offset: f = [0, 0],
  fallbackPlacements: s = ["top", "bottom", "right", "left"],
  boundary: n = "clippingParents"
}) => {
  const [m, a] = E(!1), [u, x] = E(!1), d = P(null), {
    referenceElement: k,
    isOpenState: p,
    isFocused: h,
    enabled: g,
    trigger: b,
    onShown: w,
    onHidden: T
  } = me(Xe), y = {
    ...Ut,
    ...t
  }, O = U(
    y.popoverContent,
    y.fade,
    u ? "opacity-100" : "opacity-0",
    e
  ), { styles: R, attributes: $ } = Oe(
    k.current,
    d.current,
    {
      placement: o,
      modifiers: [
        {
          name: "offset",
          options: {
            offset: f
          }
        },
        {
          name: "flip",
          options: {
            fallbackPlacements: s
          }
        },
        {
          name: "preventOverflow",
          options: {
            boundary: n
          }
        }
      ],
      ...c
    }
  ), { onTransitionShow: F, onTransitionHide: K } = we(
    d.current
  );
  return C(() => {
    if ((p || h) && g) {
      a(!0), F(() => {
        x(!0), !u && (w == null || w());
      });
      return;
    }
    x(!1), K(() => {
      a(!1), u && (T == null || T());
    });
  }, [p, h, g, b]), /* @__PURE__ */ v(be, { children: m && Pe.createPortal(
    /* @__PURE__ */ v(
      i,
      {
        className: O,
        ref: d,
        style: { ...R.popper },
        ...$.popper,
        children: r
      }
    ),
    l ? document.querySelector(l) : document.body
  ) });
}, Ee = je({
  activeIndex: -1,
  animation: !0,
  isOpenState: !1,
  setIsOpenState: () => {
  },
  setReferenceElement: () => {
  },
  setPopperElement: () => {
  },
  setActiveIndex: () => {
  },
  popperElement: null,
  referenceElement: null,
  autoClose: !0,
  onHide: () => {
  },
  onHidden: () => {
  },
  onShow: () => {
  },
  onShown: () => {
  }
}), Qt = {
  dropdown: "relative"
}, Sr = ({
  className: e,
  tag: r = "div",
  animation: t = !0,
  isOpen: i = !1,
  onHide: l,
  onHidden: o,
  onShow: c,
  onShown: f,
  children: s,
  autoClose: n = !0,
  theme: m,
  ...a
}) => {
  const [u, x] = E(i), [d, k] = E(
    null
  ), [p, h] = E(null), [g, b] = E(-1);
  C(() => {
    x(i);
  }, [i]);
  const w = {
    ...m,
    ...Qt
  }, T = U(w.dropdown, e);
  return /* @__PURE__ */ v(
    Ee.Provider,
    {
      value: {
        animation: t,
        activeIndex: g,
        isOpenState: u,
        setReferenceElement: k,
        setPopperElement: h,
        setActiveIndex: b,
        popperElement: p,
        setIsOpenState: x,
        referenceElement: d,
        autoClose: n,
        onHide: l,
        onHidden: o,
        onShow: c,
        onShown: f
      },
      children: /* @__PURE__ */ v(r, { className: T, ...a, children: s })
    }
  );
}, Jt = (e) => e instanceof HTMLElement, Zt = (e) => e instanceof Node, Vt = () => {
  const {
    isOpenState: e,
    setIsOpenState: r,
    setActiveIndex: t,
    popperElement: i,
    referenceElement: l,
    autoClose: o,
    onHide: c,
    onHidden: f
  } = me(Ee), s = oe(
    (n) => {
      !e || !Zt(n.target) || i && i.contains(n.target) || l && l.contains(n.target) || n.defaultPrevented || (c == null || c(n), r(!1), setTimeout(() => {
        t(-1), f == null || f(n);
      }, 300));
    },
    [
      e,
      r,
      t,
      i,
      l,
      c,
      f
    ]
  );
  C(() => {
    if (!(o === !1 || o === "inside"))
      return document.addEventListener("mousedown", s), () => document.removeEventListener("mousedown", s);
  }, [s, o]);
}, Br = ({
  tag: e = "button",
  children: r,
  onClick: t,
  ...i
}) => {
  const {
    setIsOpenState: l,
    setReferenceElement: o,
    isOpenState: c,
    autoClose: f,
    setActiveIndex: s,
    onHide: n,
    onHidden: m,
    onShow: a,
    onShown: u
  } = me(Ee), x = (d) => {
    t == null || t(d), !(c && (f === "outside" || f === "inside")) && (c ? n == null || n(d) : a == null || a(d), !d.defaultPrevented && (l((k) => !k), setTimeout(() => {
      s(-1), c ? m == null || m(d) : u == null || u(d);
    }, 300)));
  };
  return Vt(), /* @__PURE__ */ v(
    e,
    {
      onClick: x,
      ref: o,
      "aria-expanded": !!c,
      ...i,
      children: r
    }
  );
}, Ze = (e, r, t) => t === "up" ? e <= 0 ? r[r.length - 1].props.divider === !0 || r[r.length - 1].props.disabled === !0 : r[e - 1].props.divider === !0 || r[e - 1].props.disabled === !0 : e === r.length - 1 ? r[0].props.divider === !0 || r[0].props.disabled === !0 : r[e + 1].props.divider === !0 || r[e + 1].props.disabled === !0, Ht = (e) => {
  const {
    activeIndex: r,
    autoClose: t,
    isOpenState: i,
    setIsOpenState: l,
    setActiveIndex: o,
    onHide: c,
    onHidden: f
  } = me(Ee), s = oe(
    (n) => {
      const m = ["ArrowUp", "ArrowDown", "Tab", "Enter", "Escape"];
      if (!(!Array.isArray(e) || !m.includes(n.key))) {
        if (Jt(document.activeElement) && document.activeElement.blur(), n.key === "ArrowUp") {
          n.preventDefault();
          const a = Ze(r, e, "up");
          if (r === 1) {
            o(a ? e.length - 1 : 0);
            return;
          }
          if (r <= 0) {
            o(a ? e.length - 2 : e.length - 1);
            return;
          }
          o((u) => a ? u - 2 : u - 1);
        }
        if (n.key === "ArrowDown" || n.key === "Tab") {
          n.preventDefault();
          const a = Ze(r, e, "down");
          if (r === e.length - 2) {
            o((u) => a ? 0 : u + 1);
            return;
          }
          if (r === e.length - 1) {
            o(a ? 1 : 0);
            return;
          }
          o((u) => a ? u + 2 : u + 1);
        }
        if (n.key === "Enter" && (t === !0 || t === "inside")) {
          const a = document.querySelector(
            '[data-te-active="true"]'
          ), u = a == null ? void 0 : a.firstElementChild;
          if (u)
            return u.click();
          if (c == null || c(n), n.defaultPrevented)
            return;
          l(!1), setTimeout(() => {
            o(-1), f == null || f(n);
          }, 300);
        }
        if (n.key === "Escape" && t === !0) {
          if (c == null || c(n), n.defaultPrevented)
            return;
          l(!1), setTimeout(() => {
            o(-1), f == null || f(n);
          }, 300);
        }
      }
    },
    [
      e,
      l,
      o,
      r,
      t,
      c,
      f
    ]
  );
  C(() => (i && document.addEventListener("keydown", s), () => {
    i && document.removeEventListener("keydown", s);
  }), [i, s]), C(() => {
    const n = document.querySelector(
      '[data-te-active="true"]'
    ), m = n == null ? void 0 : n.firstElementChild;
    return m == null || m.focus(), () => m == null ? void 0 : m.blur();
  }, [r]);
}, er = {
  menu: "absolute z-[1000] float-left m-0.5 min-w-max list-none overflow-hidden rounded-lg border-none bg-white bg-clip-padding text-left text-base shadow-lg dark:bg-neutral-700",
  fade: "transition-opacity duration-300 ease-linear motion-reduce:transition-none"
}, Mr = ({
  className: e,
  tag: r = "ul",
  children: t,
  appendToBody: i = !1,
  theme: l,
  responsive: o,
  position: c,
  alignment: f = "start",
  popperConfig: s,
  display: n = "dynamic",
  offset: m = [0, 0],
  ...a
}) => {
  const [u, x] = E(window.innerWidth), [d, k] = E(
    f
  ), [p, h] = E(
    "bottom-start"
  ), [g, b] = E(!1), [w, T] = E(!1), {
    activeIndex: y,
    isOpenState: O,
    setPopperElement: R,
    animation: $,
    referenceElement: F,
    popperElement: K
  } = me(Ee), S = {
    ...l,
    ...er
  }, { onTransitionShow: j, onTransitionHide: M } = we(K);
  Ht(t);
  const N = U(
    S.menu,
    $ && S.fade,
    g ? "opacity-100" : "opacity-0",
    e
  ), D = oe(() => {
    x(window.innerWidth);
  }, []);
  C(() => {
    if (O) {
      T(!0), j(() => {
        b(!0);
      });
      return;
    }
    b(!1), M(() => {
      T(!1);
    });
  }, [O]), C(() => (window.addEventListener("resize", D), D(), () => window.removeEventListener("resize", D)), [D]), C(() => {
    k((() => {
      const G = Object.entries({
        "sm-start": 640,
        "md-start": 768,
        "lg-start": 1024,
        "xl-start": 1280,
        "2xl-start": 1536,
        "sm-end": 640,
        "md-end": 768,
        "lg-end": 1024,
        "xl-end": 1280,
        "2xl-end": 1536
      }).find(
        ([J, q]) => o === J && u >= q
      );
      return G ? G == null ? void 0 : G[0].split("-")[1] : f;
    })());
  }, [o, f, u, d]), C(() => {
    h((() => {
      if (c === "dropright")
        return "right-start";
      if (c === "dropleft")
        return "left-start";
      const X = K && d === "end";
      return c === "dropup" ? X ? "top-end" : "top-start" : X ? "bottom-end" : "bottom-start";
    })());
  }, [c, f, d, K]);
  const { styles: B } = Oe(
    F,
    K,
    n === "dynamic" ? {
      placement: p,
      modifiers: [
        Ct,
        {
          name: "offset",
          options: {
            offset: m
          }
        }
      ],
      ...s
    } : {
      modifiers: [
        {
          name: "applyStyles",
          enabled: !1
        }
      ]
    }
  ), W = /* @__PURE__ */ v(
    r,
    {
      className: N,
      ref: R,
      style: {
        position: "absolute",
        zIndex: 1e3,
        ...n === "dynamic" ? B.popper : {}
      },
      alignment: d,
      ...a,
      children: Lt.map(
        t,
        (z, X) => _t(z, {
          tabIndex: X,
          "data-te-active": y === X && !0
        })
      )
    }
  );
  return /* @__PURE__ */ v(be, { children: w && (i ? tt(W, document.body) : W) });
}, zr = ({
  tag: e = "li",
  onClick: r,
  children: t,
  preventCloseOnClick: i,
  ...l
}) => {
  const { autoClose: o, setIsOpenState: c, onHide: f, onHidden: s, setActiveIndex: n } = me(Ee);
  return /* @__PURE__ */ v(e, { onClick: (a) => {
    i || a.defaultPrevented || (o === !0 || o === "inside") && (f == null || f(a), r == null || r(a), setTimeout(() => {
      n(-1), s == null || s(a);
    }, 300), c(!1));
  }, ...l, children: t });
}, tr = () => {
  const e = P(null), [r, t] = E(!1);
  C(() => {
    (async () => {
      const {
        Chart: m,
        ArcElement: a,
        LineElement: u,
        BarElement: x,
        PointElement: d,
        BarController: k,
        BubbleController: p,
        DoughnutController: h,
        LineController: g,
        PieController: b,
        PolarAreaController: w,
        RadarController: T,
        ScatterController: y,
        CategoryScale: O,
        LinearScale: R,
        LogarithmicScale: $,
        RadialLinearScale: F,
        TimeScale: K,
        TimeSeriesScale: S,
        Decimation: j,
        Filler: M,
        Legend: N,
        Title: D,
        Tooltip: B,
        SubTitle: W
      } = await import("chart.js");
      m.register(
        a,
        u,
        x,
        d,
        k,
        p,
        h,
        g,
        b,
        w,
        T,
        y,
        O,
        R,
        $,
        F,
        K,
        S,
        j,
        M,
        N,
        D,
        B,
        W
      ), e.current = m, t(!0);
    })();
  }, []);
  const i = (n, m, a, u, x) => {
    if (n.current && a && e.current)
      return new e.current(n.current, { type: m, data: a, options: u, plugins: x });
  }, l = (n, m, a) => {
    n || (n = {});
    const u = (x, d, k) => {
      const p = x.slice();
      return d.forEach((h, g) => {
        typeof p[g] > "u" ? p[g] = k.cloneUnlessOtherwiseSpecified(
          h,
          k
        ) : k.isMergeableObject(h) ? p[g] = Je(x[g], h, k) : x.indexOf(h) === -1 && p.push(h);
      }), p;
    };
    return Je(a[m], n, {
      arrayMerge: u
    });
  }, o = (n, m, a) => {
    n.options = a, n.data = m, n.update();
  }, c = (n, m) => {
    var u;
    let a = "";
    return n || (a = m === "dark" ? "dark" : m ? "light" : localStorage.theme || ((u = document.querySelector("html")) != null && u.classList.contains("dark") ? "dark" : "light")), a;
  }, f = (n, m, a, u, x) => {
    const d = {
      scales: {
        y: {
          ticks: {
            color: m
          },
          grid: {
            color: u
          }
        },
        x: {
          ticks: {
            color: m
          },
          grid: {
            color: u
          }
        }
      }
    }, k = {
      scales: {
        r: {
          ticks: {
            color: m,
            backdropColor: x
          },
          grid: {
            color: u
          },
          pointLabels: {
            color: m
          }
        }
      }
    }, p = {
      plugins: {
        legend: {
          labels: {
            color: a
          }
        }
      }
    }, g = ["pie", "doughnut", "polarArea", "radar"].includes(n) ? ["radar"].includes(n) ? {
      ...k,
      ...p
    } : ["polarArea"].includes(n) ? { ...k, borderColor: "#262626", ...p } : ["pie", "doughnut"].includes(n) ? {
      borderColor: "#262626",
      ...p
    } : {} : {
      ...d,
      ...p
    };
    return l(g, n, s);
  }, s = {
    line: {
      elements: {
        line: {
          backgroundColor: "rgba(59, 112, 202, 0.0)",
          borderColor: "rgb(59, 112, 202)",
          borderWidth: 2,
          tension: 0
        },
        point: {
          borderColor: "rgb(59, 112, 202)",
          backgroundColor: "rgb(59, 112, 202)"
        }
      },
      responsive: !0,
      plugins: {
        tooltip: {
          intersect: !1,
          mode: "index"
        },
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      },
      scales: {
        x: {
          stacked: !0,
          grid: {
            display: !1
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        },
        y: {
          stacked: !1,
          grid: {
            borderDash: [2],
            drawBorder: !1,
            zeroLineColor: "rgba(0,0,0,0)",
            zeroLineBorderDash: [2],
            zeroLineBorderDashOffset: [2]
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        }
      }
    },
    bar: {
      backgroundColor: "rgb(59, 112, 202)",
      borderWidth: 0,
      responsive: !0,
      plugins: {
        tooltip: {
          intersect: !1,
          mode: "index"
        },
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      },
      scales: {
        x: {
          stacked: !0,
          grid: {
            display: !1
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        },
        y: {
          stacked: !0,
          grid: {
            borderDash: [2],
            drawBorder: !1,
            zeroLineColor: "rgba(0,0,0,0)",
            zeroLineBorderDash: [2],
            zeroLineBorderDashOffset: [2]
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        }
      }
    },
    pie: {
      elements: {
        arc: { backgroundColor: "rgb(59, 112, 202)" }
      },
      borderColor: "#fff",
      responsive: !0,
      plugins: {
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      }
    },
    doughnut: {
      elements: {
        arc: { backgroundColor: "rgb(59, 112, 202)" }
      },
      responsive: !0,
      plugins: {
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      }
    },
    polarArea: {
      elements: {
        arc: { backgroundColor: "rgba(59, 112, 202, 0.5)" }
      },
      responsive: !0,
      plugins: {
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      }
    },
    radar: {
      elements: {
        line: {
          backgroundColor: "rgba(59, 112, 202, 0.5)",
          borderColor: "rgb(59, 112, 202)",
          borderWidth: 2
        },
        point: {
          borderColor: "rgb(59, 112, 202)",
          backgroundColor: "rgb(59, 112, 202)"
        }
      },
      responsive: !0,
      plugins: {
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      }
    },
    scatter: {
      elements: {
        line: {
          backgroundColor: "rgba(59, 112, 202, 0.5)",
          borderColor: "rgb(59, 112, 202)",
          borderWidth: 2,
          tension: 0
        },
        point: {
          borderColor: "rgb(59, 112, 202)",
          backgroundColor: "rgba(59, 112, 202, 0.5)"
        }
      },
      responsive: !0,
      plugins: {
        tooltip: {
          intersect: !1,
          mode: "index"
        },
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      },
      datasets: {
        borderColor: "red"
      },
      scales: {
        x: {
          stacked: !0,
          grid: {
            display: !1
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        },
        y: {
          stacked: !1,
          grid: {
            borderDash: [2],
            drawBorder: !1,
            zeroLineColor: "rgba(0,0,0,0)",
            zeroLineBorderDash: [2],
            zeroLineBorderDashOffset: [2]
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        }
      }
    },
    bubble: {
      elements: {
        point: {
          borderColor: "rgb(59, 112, 202)",
          backgroundColor: "rgba(59, 112, 202, 0.5)"
        }
      },
      responsive: !0,
      plugins: {
        legend: {
          display: !0,
          labels: {
            color: "rgb(102,102,102)"
          }
        }
      },
      scales: {
        x: {
          grid: {
            display: !1
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        },
        y: {
          grid: {
            borderDash: [2],
            drawBorder: !1,
            zeroLineColor: "rgba(0,0,0,0)",
            zeroLineBorderDash: [2],
            zeroLineBorderDashOffset: [2]
          },
          ticks: {
            fontColor: "rgba(0,0,0, 0.5)"
          }
        }
      }
    }
  };
  return {
    defaultOptions: s,
    setupOptions: l,
    getChart: i,
    getColorMode: c,
    updateChart: o,
    getDarkConfig: f,
    chartsLoaded: r
  };
}, Fr = ({
  type: e,
  data: r,
  options: t,
  darkOptions: i,
  chartRef: l,
  datalabels: o,
  disableDarkMode: c,
  darkMode: f,
  darkTicksColor: s = "#fff",
  darkLabelColor: n = "#fff",
  darkGridLinesColor: m = "#555",
  darkBgColor: a = "#262626",
  ...u
}) => {
  const x = P(null), {
    defaultOptions: d,
    setupOptions: k,
    getChart: p,
    getColorMode: h,
    getDarkConfig: g,
    updateChart: b,
    chartsLoaded: w
  } = tr(), [T, y] = E(
    h(c || !1, f || "")
  ), O = P(void 0), R = P(null), $ = P(null), F = l || R, K = g(
    e,
    s,
    n,
    m,
    a
  ), S = T === "dark" ? { ...K, ...i } : t;
  return C(() => {
    const j = o ? [x.current] : [], M = p(
      F,
      e,
      r,
      k(S, e, d),
      j
    );
    return O.current = M, () => {
      M == null || M.destroy();
    };
  }, [F, e, o, w]), C(() => {
    O.current && b(
      O.current,
      r,
      k(S, e, d)
    );
  }, [
    t,
    i,
    S,
    r,
    O.current,
    w
  ]), C(() => {
    if (c)
      return;
    if (f) {
      y(f);
      return;
    }
    const j = document.querySelector("html");
    if (!(!j || $.current !== null))
      return $.current = new MutationObserver((M) => {
        M.forEach((N) => {
          N.attributeName === "class" && j.classList.contains("dark") ? y("dark") : y("light");
        });
      }), $.current.observe(j, { attributes: !0 }), () => {
        var M;
        (M = $.current) == null || M.disconnect(), $.current = null;
      };
  }, [c, f]), C(() => {
    (async () => {
      const M = await import("chartjs-plugin-datalabels");
      x.current = M.default;
    })();
  }, []), /* @__PURE__ */ v(be, { children: /* @__PURE__ */ v("canvas", { ref: F, ...u }) });
}, rr = {
  tooltip: "z-[1080] block p-1 not-italic font-normal no-underline underline-offset-auto normal-case leading-6 tracking-normal break-normal whitespace-normal",
  tooltipInner: "max-w-[200px] text-sm py-1.5 px-4 text-white text-center bg-[#6d6d6d] rounded-[0.25rem]",
  fade: "transition-opacity ease-linear motion-reduce:transition-none"
}, $r = ({
  className: e,
  children: r,
  tag: t = "button",
  tooltipTag: i = "div",
  popperConfig: l,
  placement: o = "top",
  title: c,
  wrapperProps: f,
  tooltipClassName: s,
  theme: n,
  container: m = !1,
  trigger: a = "hover focus",
  offset: u = [0, 0],
  fallbackPlacements: x = ["top", "right", "bottom", "left"],
  boundary: d = "clippingParents",
  enabled: k = !0,
  onShow: p,
  onShown: h,
  onHide: g,
  onHidden: b,
  onMouseEnter: w,
  onMouseLeave: T,
  ...y
}) => {
  const [O, R] = E(!1), [$, F] = E(!1), [K, S] = E(!1), [j, M] = E(!1), N = P(null), D = P(null), B = P(!1), W = {
    ...rr,
    ...n
  }, z = U(
    W.tooltip,
    W.fade,
    K ? "opacity-100" : "opacity-0",
    s
  ), { styles: X, attributes: G } = Oe(
    D.current,
    N.current,
    {
      placement: o,
      modifiers: [
        {
          name: "offset",
          options: {
            offset: u
          }
        },
        {
          name: "flip",
          options: {
            fallbackPlacements: x
          }
        },
        {
          name: "preventOverflow",
          options: {
            boundary: d
          }
        }
      ],
      ...l
    }
  ), { onTransitionShow: J, onTransitionHide: q } = we(
    N.current
  );
  C(() => {
    if ((O || $) && k) {
      if (B.current)
        return;
      B.current = !0, M(!0), J(() => {
        S(!0), h == null || h();
      });
      return;
    }
    S(!1), q(() => {
      M(!1), K && (b == null || b()), B.current = !1;
    });
  }, [O, $, k]);
  const te = oe(
    (Q, I) => {
      if (k)
        if (I === "mouseenter" && (w == null || w(Q)), I === "mouseleave" && (T == null || T(Q)), (I === "mouseenter" || I === "mouseleave") && a !== "click" && a !== "focus" || I === "mouseleave" && a.includes("click")) {
          if (I === "mouseenter" && $ || I === "mouseleave" && !O || a.includes("click") && a.includes("focus") && !a.includes("hover"))
            return;
          I === "mouseenter" ? (!$ && (p == null || p(Q)), !Q.defaultPrevented && R(!0)) : (!$ && (g == null || g(Q)), !Q.defaultPrevented && R(!1));
        } else
          I === "mousedown" && (Q.target === D.current ? a.includes("focus") ? (!$ && !O && (p == null || p(Q)), F(!0)) : a.includes("click") && (!O && (p == null || p(Q)), R(!0)) : a.includes("focus") ? ($ && (g == null || g(Q)), F(!1)) : a.includes("click") && (O && (g == null || g(Q)), R(!1)));
    },
    [k, a, O, $]
  );
  return C(() => {
    if (!k)
      return;
    const Q = (I) => {
      te(I, "mousedown");
    };
    return document.addEventListener("mousedown", Q), () => {
      document.removeEventListener("mousedown", Q);
    };
  }, [k, te]), /* @__PURE__ */ ne(be, { children: [
    /* @__PURE__ */ v(
      t,
      {
        className: e,
        onMouseEnter: (Q) => te(Q, "mouseenter"),
        onMouseLeave: (Q) => te(Q, "mouseleave"),
        ref: D,
        ...f,
        children: r
      }
    ),
    j && Pe.createPortal(
      /* @__PURE__ */ v(
        i,
        {
          ref: N,
          className: z,
          style: X.popper,
          ...G.popper,
          role: "tooltip",
          ...y,
          children: /* @__PURE__ */ v("div", { className: W.tooltipInner, children: c })
        }
      ),
      m ? document.querySelector(m) : document.body
    )
  ] });
}, nr = {
  wrapper: "relative",
  input: "peer block min-h-[auto] w-full rounded border-0 bg-transparent outline-none transition-all duration-200 ease-linear focus:placeholder:opacity-100 peer-focus:text-primary motion-reduce:transition-none placeholder:opacity-0 disabled:bg-neutral-100 read-only:bg-neutral-100 dark:disabled:bg-neutral-700 dark:read-only:bg-neutral-700 dark:placeholder:text-neutral-200 dark:peer-focus:text-primary",
  inputDefault: "text-neutral-800 dark:text-neutral-200",
  inputWhite: "text-white",
  activeInput: "placeholder:opacity-100",
  label: "pointer-events-none absolute left-3 top-0 mb-0 max-w-[90%] origin-[0_0] truncate transition-all duration-200 ease-out peer-focus:scale-[0.8] motion-reduce:transition-none",
  labelDefault: "text-neutral-500 dark:text-neutral-200 peer-focus:text-primary dark:peer-focus:text-primary",
  labelWhite: "text-white",
  activeLabel: "scale-[0.8]",
  notch: "group flex absolute left-0 top-0 w-full max-w-full h-full text-left pointer-events-none",
  notchLeading: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none left-0 top-0 h-full w-2 border-r-0 rounded-l-[0.25rem]",
  activeNotchLeading: "border-r-0",
  focusedNotchLeading: "border-r-0",
  notchLeadingDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchLeadingDefault: "shadow-[-1px_0_0_#3b71ca,_0_1px_0_0_#3b71ca,_0_-1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchLeadingWhite: "border-neutral-200",
  focusedNotchLeadingWhite: "shadow-[-1px_0_0_#ffffff,_0_1px_0_0_#ffffff,_0_-1px_0_0_#ffffff] border-white",
  notchMiddle: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none grow-0 shrink-0 basis-auto w-auto max-w-[calc(100%-1rem)] h-full border-r-0 border-l-0",
  activeNotchMiddle: "border-x-0 border-t border-solid border-t-transparent dark:border-t-transparent",
  focusedNotchMiddle: "border-x-0 border-t border-solid border-t-transparent dark:border-t-transparent",
  notchMiddleDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchMiddleDefault: "shadow-[0_1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchMiddleWhite: "border-neutral-200",
  focusedNotchMiddleWhite: "shadow-[0_1px_0_0_#ffffff] border-white",
  notchTrailing: "pointer-events-none border border-solid box-border bg-transparent transition-all duration-200 ease-linear motion-reduce:transition-none grow h-full border-l-0 rounded-r-[0.25rem]",
  activeNotchTrailing: "border-l-0",
  focusedNotchTrailing: "border-l-0",
  notchTrailingDefault: "border-neutral-300 dark:border-neutral-600",
  focusedNotchTrailingDefault: "shadow-[1px_0_0_#3b71ca,_0_-1px_0_0_#3b71ca,_0_1px_0_0_#3b71ca] border-primary dark:border-primary",
  notchTrailingWhite: "border-neutral-200",
  focusedNotchTrailingWhite: "shadow-[1px_0_0_#ffffff,_0_-1px_0_0_#ffffff,_0_1px_0_0_#ffffff] border-white",
  counter: "text-right leading-[1.6]",
  inputSizeLg: "px-3 py-[0.32rem] leading-[2.15]",
  inputSizeBase: "px-3 py-[0.32rem] leading-[1.6]",
  inputSizeSm: "px-3 py-[0.33rem] text-xs leading-[1.5]",
  labelSizeLg: "pt-[0.36rem] leading-[2.15] peer-focus:-translate-y-[1.15rem]",
  activeLabelSizeLg: "-translate-y-[1.15rem]",
  labelSizeBase: "pt-[0.30rem] leading-[1.6] peer-focus:-translate-y-[0.9rem]",
  activeLabelSizeBase: "-translate-y-[0.9rem]",
  labelSizeSm: "pt-[0.36rem] text-xs leading-[1.5] peer-focus:-translate-y-[0.75rem]",
  activeLabelSizeSm: "-translate-y-[0.75rem]"
}, jr = ({
  className: e,
  size: r = "base",
  value: t,
  defaultValue: i,
  id: l,
  wrapperTag: o = "div",
  label: c,
  onChange: f,
  children: s,
  labelRef: n,
  labelID: m,
  inputRef: a,
  onBlur: u,
  readonly: x = !1,
  theme: d,
  formWhite: k = !1,
  counter: p = !1,
  maxLength: h,
  ...g
}) => {
  const b = { ...nr, ...d }, w = P(null), T = a || w, {
    labelReference: y,
    labelWidth: O,
    newValue: R,
    setWidth: $,
    setFocus: F,
    handleChange: K,
    handleBlur: S,
    inputClasses: j,
    labelClasses: M,
    notchLeadingClasses: N,
    notchMiddleClasses: D,
    notchTrailingClasses: B
  } = nt(
    w,
    n,
    t,
    i,
    u,
    f,
    p,
    h,
    b,
    r,
    e,
    k
  );
  return /* @__PURE__ */ ne(o, { children: [
    /* @__PURE__ */ ne(o, { className: b.wrapper, children: [
      /* @__PURE__ */ v(
        "textarea",
        {
          id: l,
          ref: T,
          readOnly: x,
          className: j,
          value: t,
          defaultValue: i,
          onBlur: (W) => {
            S(W), F(!1);
          },
          onChange: K,
          onFocus: () => {
            F(!0);
          },
          maxLength: h,
          ...g
        }
      ),
      c && /* @__PURE__ */ v(
        "label",
        {
          id: m,
          className: M,
          htmlFor: l,
          ref: y,
          children: c
        }
      ),
      /* @__PURE__ */ ne("div", { className: b.notch, children: [
        /* @__PURE__ */ v("div", { className: N }),
        /* @__PURE__ */ v(
          "div",
          {
            className: D,
            style: { width: O }
          }
        ),
        /* @__PURE__ */ v("div", { className: B })
      ] }),
      s
    ] }),
    p && h !== void 0 && h > 0 && /* @__PURE__ */ v("div", { className: b.counter, children: /* @__PURE__ */ ne("span", { children: [
      (R == null ? void 0 : R.toString().length) || 0,
      " / ",
      h
    ] }) })
  ] });
}, or = {
  wrapper: "inline-flex mb-3 items-center rounded-lg px-6 py-5 text-base",
  wrapperTransition: "transition duration-300 ease-in-out motion-reduce:transition-none",
  wrapperVisible: "opacity-100",
  wrapperHidden: "opacity-0",
  static: "w-full",
  nonStatic: "fixed top-4 right-4",
  dismissButton: "w-[1em] focus:opacity-100 disabled:pointer-events-none disabled:select-none disabled:opacity-25",
  dismissButtonWrapper: "ml-auto box-content rounded-none border-none p-1 text-warning-900 opacity-50 hover:text-warning-900 hover:no-underline hover:opacity-75 focus:opacity-100 focus:shadow-none focus:outline-none"
}, Xr = ({
  open: e = !1,
  setOpen: r,
  className: t,
  autohide: i,
  animation: l = !0,
  children: o,
  color: c = "bg-primary-100 text-primary-800",
  delay: f = 1e3,
  dismiss: s,
  dismissTemplate: n,
  staticAlert: m,
  tag: a = "div",
  theme: u,
  onClose: x,
  onClosed: d,
  ...k
}) => {
  const [p, h] = E(!1), [g, b] = E(!1), w = P(void 0), T = P(null), y = {
    ...or,
    ...u
  }, O = U(
    y.wrapper,
    c,
    l && y.wrapperTransition,
    m ? y.static : y.nonStatic,
    p ? y.wrapperVisible : y.wrapperHidden,
    t
  ), { onTransitionShow: R, onTransitionHide: $ } = we(
    T.current
  );
  return C(() => {
    if (e) {
      b(!0);
      return;
    }
    h(!1);
  }, [e]), C(() => {
    if (g)
      return R(() => {
        h(!0), i && (w.current = setTimeout(() => {
          h(!1);
        }, f));
      }), () => clearTimeout(w.current);
  }, [g]), C(() => {
    p ? b(!0) : !p && g && (x == null || x(), $(() => {
      b(!1), r == null || r(!1), d == null || d();
    }));
  }, [p]), /* @__PURE__ */ v(be, { children: g && /* @__PURE__ */ ne(a, { className: O, ...k, role: "alert", ref: T, children: [
    o,
    s && /* @__PURE__ */ v(
      "button",
      {
        type: "button",
        className: y.dismissButtonWrapper,
        "aria-label": "Close",
        onClick: () => h(!1),
        children: /* @__PURE__ */ v("span", { className: y.dismissButton, children: n || /* @__PURE__ */ v(
          "svg",
          {
            xmlns: "http://www.w3.org/2000/svg",
            viewBox: "0 0 24 24",
            fill: "currentColor",
            className: "h-6 w-6",
            children: /* @__PURE__ */ v(
              "path",
              {
                fillRule: "evenodd",
                d: "M5.47 5.47a.75.75 0 011.06 0L12 10.94l5.47-5.47a.75.75 0 111.06 1.06L13.06 12l5.47 5.47a.75.75 0 11-1.06 1.06L12 13.06l-5.47 5.47a.75.75 0 01-1.06-1.06L10.94 12 5.47 6.53a.75.75 0 010-1.06z",
                clipRule: "evenodd"
              }
            )
          }
        ) })
      }
    )
  ] }) });
}, sr = {
  wrapper: "pointer-events-auto mx-auto w-96 max-w-full rounded-lg bg-clip-padding text-sm shadow-lg shadow-black/5",
  wrapperTransition: "transition duration-300 ease-in-out motion-reduce:transition-none",
  wrapperVisible: "opacity-100",
  wrapperHidden: "opacity-0",
  nonStatic: "fixed top-4 right-4"
}, qr = ({
  open: e = !1,
  setOpen: r,
  className: t,
  autohide: i,
  animation: l = !0,
  children: o,
  color: c = "bg-white dark:bg-neutral-600 dark:border-opacity-50 dark:bg-neutral-600",
  delay: f = 1e3,
  staticToast: s,
  tag: n = "div",
  theme: m,
  onClose: a,
  onClosed: u,
  onShow: x,
  onShown: d,
  ...k
}) => {
  const [p, h] = E(!1), [g, b] = E(!1), w = P(void 0), T = P(null), y = {
    ...sr,
    ...m
  }, O = U(
    y.wrapper,
    c,
    l && y.wrapperTransition,
    !s && y.nonStatic,
    p ? y.wrapperVisible : y.wrapperHidden,
    t
  ), { onTransitionShow: R, onTransitionHide: $ } = we(
    T.current
  ), F = () => {
    var j, M;
    p && !s && ((j = T.current) == null || j.addEventListener("mouseenter", () => {
      clearTimeout(w.current);
    }), (M = T.current) == null || M.addEventListener("mouseleave", S));
  }, K = () => {
    var j, M;
    (j = T.current) == null || j.removeEventListener("mouseenter", () => {
      clearTimeout(w.current);
    }), (M = T.current) == null || M.removeEventListener("mouseleave", S);
  }, S = () => {
    i && (w.current = setTimeout(() => {
      h(!1);
    }, f));
  };
  return C(() => {
    if (e) {
      b(!0);
      return;
    }
    h(!1);
  }, [e]), C(() => {
    if (g)
      return R(() => {
        h(!0), S();
      }), () => {
        K(), clearTimeout(w.current);
      };
  }, [g]), C(() => {
    p ? (b(!0), x == null || x(), F(), d == null || d()) : !p && g && (a == null || a(), K(), $(() => {
      b(!1), r == null || r(!1), u == null || u();
    }));
  }, [p]), /* @__PURE__ */ v(be, { children: g && /* @__PURE__ */ v(
    n,
    {
      className: O,
      ...k,
      ref: T,
      role: "alert",
      "aria-live": "assertive",
      "aria-atomic": "true",
      children: o
    }
  ) });
}, ar = {
  dropdown: "relative outline-none min-w-[100px] m-0 bg-white shadow-[0_2px_5px_0_rgba(0,0,0,0.16),_0_2px_10px_0_rgba(0,0,0,0.12)] transition duration-200 motion-reduce:transition-none dark:bg-zinc-700",
  dropdownVisible: "opacity-100 scale-100",
  dropdownHidden: "opacity-0 scale-[0.8]",
  formCheckInput: "relative float-left mt-[0.15rem] mr-[8px] h-[1.125rem] w-[1.125rem] appearance-none rounded-[0.25rem] border-[0.125rem] border-solid border-neutral-300 dark:border-neutral-600 outline-none before:pointer-events-none before:absolute before:h-[0.875rem] before:w-[0.875rem] before:scale-0 before:rounded-full before:bg-transparent before:opacity-0 before:shadow-[0px_0px_0px_13px_transparent] before:content-[''] checked:border-primary dark:checked:border-primary checked:bg-primary dark:checked:bg-primary checked:before:opacity-[0.16] checked:after:absolute checked:after:ml-[0.25rem] checked:after:-mt-px checked:after:block checked:after:h-[0.8125rem] checked:after:w-[0.375rem] checked:after:rotate-45 checked:after:border-[0.125rem] checked:after:border-t-0 checked:after:border-l-0 checked:after:border-solid checked:after:border-white checked:after:bg-transparent checked:after:content-[''] hover:cursor-pointer hover:before:opacity-[0.04] hover:before:shadow-[0px_0px_0px_13px_rgba(0,0,0,0.6)] focus:shadow-none focus:transition-[border-color_0.2s] focus:before:scale-100 focus:before:opacity-[0.12] focus:before:shadow-[0px_0px_0px_13px_rgba(0,0,0,0.6)] dark:focus:before:shadow-[0px_0px_0px_13px_rgba(255,255,255,0.4)] focus:before:transition-[box-shadow_0.2s,transform_0.2s] focus:after:absolute focus:after:z-[1] focus:after:block focus:after:h-[0.875rem] focus:after:w-[0.875rem] focus:after:rounded-[0.125rem] focus:after:content-[''] checked:focus:before:scale-100 checked:focus:before:shadow-[0px_0px_0px_13px_#3b71ca] dark:checked:focus:before:shadow-[0px_0px_0px_13px_#3b71ca] checked:focus:before:transition-[box-shadow_0.2s,transform_0.2s] checked:focus:after:ml-[0.25rem] checked:focus:after:-mt-px checked:focus:after:h-[0.8125rem] checked:focus:after:w-[0.375rem] checked:focus:after:rotate-45 checked:focus:after:rounded-none checked:focus:after:border-[0.125rem] checked:focus:after:border-t-0 checked:focus:after:border-l-0 checked:focus:after:border-solid checked:focus:after:border-white checked:focus:after:bg-transparent",
  formOutline: "relative",
  inputGroup: "flex items-center whitespace-nowrap p-2.5 text-center text-base font-normal leading-[1.6] text-gray-700 dark:bg-zinc-800 dark:text-gray-200 dark:placeholder:text-gray-200",
  noResult: "flex items-center px-4",
  optionsList: "list-none m-0 p-0",
  optionsWrapper: "overflow-y-auto",
  optionsWrapperScrollbar: "[&::-webkit-scrollbar]:w-1 [&::-webkit-scrollbar]:h-1 [&::-webkit-scrollbar-button]:block [&::-webkit-scrollbar-button]:h-0 [&::-webkit-scrollbar-button]:bg-transparent [&::-webkit-scrollbar-track-piece]:bg-transparent [&::-webkit-scrollbar-track-piece]:rounded-none [&::-webkit-scrollbar-track-piece]: [&::-webkit-scrollbar-track-piece]:rounded-l [&::-webkit-scrollbar-thumb]:h-[50px] [&::-webkit-scrollbar-thumb]:bg-[#999] [&::-webkit-scrollbar-thumb]:rounded",
  selectArrow: "absolute right-3 text-[0.8rem] cursor-pointer w-5 h-5 pointer-events-none",
  selectArrowFocused: "text-primary",
  selectArrowWhite: "text-gray-50",
  selectArrowWhiteFocused: "!text-white",
  selectArrowDefault: "top-2",
  selectArrowLg: "top-[13px]",
  selectArrowSm: "top-1",
  selectClearBtn: "absolute top-2 right-9 text-black cursor-pointer focus:text-primary outline-none dark:text-gray-200 w-5 h-5",
  selectClearBtnWhite: "!text-gray-50",
  selectClearBtnDefault: "top-2 text-base",
  selectClearBtnLg: "top-[11px] text-base",
  selectClearBtnSm: "top-1 text-[0.8rem]",
  selectDropdownContainer: "z-[1070]",
  selectFilterInput: "relative m-0 block w-full min-w-0 flex-auto rounded border border-solid border-gray-300 bg-transparent bg-clip-padding px-3 py-1.5 text-base font-normal text-gray-700 transition duration-300 ease-in-out motion-reduce:transition-none focus:border-primary focus:text-gray-700 focus:shadow-te-primary focus:outline-none dark:text-gray-200 dark:placeholder:text-gray-200",
  selectInput: "peer block min-h-[auto] w-full rounded border-0 bg-transparent outline-none transition-all duration-200 ease-linear peer-focus:text-primary motion-reduce:transition-none disabled:bg-neutral-100 dark:disabled:bg-neutral-700 dark:text-neutral-200 dark:placeholder:text-neutral-200 dark:peer-focus:text-primary cursor-pointer disabled:cursor-default",
  selectLabel: "pointer-events-none absolute left-3 top-0 mb-0 max-w-[90%] origin-[0_0] truncate text-neutral-500 transition-all duration-200 ease-out peer-focus:scale-[0.8] peer-focus:text-primary motion-reduce:transition-none dark:text-neutral-200 dark:peer-focus:text-primary",
  selectOption: "flex flex-row items-center justify-between w-full px-4 truncate select-none",
  selectOptionDefault: "bg-transparent text-gray-700 dark:text-gray-200",
  selectOptionDisabled: "cursor-default text-gray-400 bg-transparent dark:text-gray-400",
  selectOptionSelected: "bg-black/5 dark:bg-white/30",
  selectOptionActive: "bg-black/5 dark:bg-white/30",
  selectOptionNonDisabled: "hover:bg-black/5 dark:hover:bg-white/30 cursor-pointer",
  selectOptionsMultipleActive: "bg-black/5 dark:bg-white/30",
  selectOptionsOptGroup: "pl-7",
  selectOptionGroup: "group/opt pointer-none",
  selectOptionGroupLabel: "flex flex-row items-center w-full px-4 truncate bg-transparent text-black/50 select-none dark:text-gray-300",
  selectOptionIcon: "w-7 h-7 rounded-full",
  selectOptionSecondaryText: "block text-[0.8rem] text-gray-500 dark:text-gray-300"
}, ir = 0, lr = ({
  data: e,
  selectData: r,
  selectedElements: t,
  optionHeight: i,
  handleOptionClick: l,
  handleSelectAll: o,
  selectAll: c,
  selectAllLabel: f,
  multiple: s,
  activeElementIndex: n,
  search: m,
  noResultsText: a,
  theme: u = {}
}) => {
  const x = ({
    disabled: b,
    selected: w,
    active: T,
    hidden: y,
    group: O
  }) => U(
    u.selectOption,
    !b && !w && !T && u.selectOptionDefault,
    !b && u.selectOptionNonDisabled,
    b && u.selectOptionDisabled,
    y && "hidden",
    w && u.selectOptionSelected,
    T && u.selectOptionActive,
    O && u.selectOptionsOptGroup
  ), d = Ae(() => r.filter((w) => w.optgroup).map((w) => w.text), [r]), k = Ae(() => {
    let b = 0;
    return r.map((T) => (T.optgroup && b++, { ...T, groupIndex: b }));
  }, [r]), p = Ae(() => r.filter((b) => !b.optgroup && !b.hidden).length === 0, [r]), h = (b) => /* @__PURE__ */ ne(be, { children: [
    /* @__PURE__ */ ne("span", { className: "group", children: [
      s && /* @__PURE__ */ v(
        "input",
        {
          className: u.formCheckInput,
          type: "checkbox",
          checked: t.includes(b.elementPosition),
          readOnly: !0
        }
      ),
      b.text,
      b.secondaryText && /* @__PURE__ */ v("span", { className: u.selectOptionSecondaryText, children: b.secondaryText })
    ] }),
    b.icon && /* @__PURE__ */ v("span", { children: /* @__PURE__ */ v("img", { className: u.selectOptionIcon, src: b.icon }) })
  ] }), g = (b) => k.map((w) => {
    if (!w.optgroup && b === w.groupIndex)
      return /* @__PURE__ */ v(
        "div",
        {
          className: x({
            selected: t.includes(w.elementPosition),
            disabled: w.disabled || !1,
            hidden: w.hidden || !1,
            active: n === w.elementPosition,
            group: !!w.groupIndex
          }),
          style: { height: `${i}px` },
          role: "option",
          "aria-selected": t.includes(w.elementPosition),
          "aria-disabled": w.disabled,
          onClick: () => l(w),
          children: h(w)
        },
        w.elementPosition
      );
  });
  return /* @__PURE__ */ ne(be, { children: [
    s && c && !p && /* @__PURE__ */ v(
      "div",
      {
        className: x({
          disabled: !1,
          hidden: !1,
          selected: t.length === e.filter((b) => !b.disabled).length,
          active: n === -1,
          group: !1
        }),
        style: { height: `${i}px` },
        onClick: o,
        role: "option",
        "aria-selected": t.length === e.filter((b) => !b.disabled).length,
        children: /* @__PURE__ */ ne("span", { children: [
          /* @__PURE__ */ v(
            "input",
            {
              className: u.formCheckInput,
              type: "checkbox",
              checked: e.filter((b) => !b.disabled && !b.optgroup).length === t.length,
              role: "option",
              readOnly: !0
            }
          ),
          f
        ] })
      }
    ),
    /* @__PURE__ */ ne("div", { className: u.optionsList, children: [
      g(ir),
      !p && (d == null ? void 0 : d.map((b, w) => {
        const T = g(w + 1).filter(
          (y) => y !== void 0
        );
        if (T.length !== 0)
          return /* @__PURE__ */ ne(
            "div",
            {
              className: u.selectOptionGroup,
              children: [
                /* @__PURE__ */ v(
                  "label",
                  {
                    className: u.selectOptionGroupLabel,
                    style: { height: i },
                    children: b
                  }
                ),
                T
              ]
            },
            `select-option-group ${b} ${w}`
          );
      }))
    ] }),
    m && p && /* @__PURE__ */ v("div", { className: u.noResult, style: { height: `${i}px` }, children: a })
  ] });
}, Fe = "ArrowUp", $e = "ArrowDown", Ve = "Enter", He = "Escape", et = "Tab", cr = (e, r) => {
  if (e.length !== r.length)
    return !1;
  for (let t = 0; t < e.length; t++) {
    const i = e[t], l = r[t], o = Object.keys(i), c = Object.keys(l);
    if (o.length !== c.length || !o.every((f) => c.includes(f)) || !o.every((f) => i[f] === l[f]))
      return !1;
  }
  return !0;
}, ke = -1, Yr = ({
  open: e = !1,
  setOpen: r,
  data: t,
  className: i,
  optionHeight: l = 38,
  visibleOptions: o = 5,
  disabled: c,
  placeholder: f,
  label: s,
  clearBtn: n,
  children: m,
  multiple: a,
  displayedLabels: u = 5,
  optionsSelectedLabel: x = "options selected",
  selectAll: d = !0,
  selectAllLabel: k = "Select all",
  size: p,
  showRef: h,
  contrast: g = !1,
  onOpen: b,
  onClose: w,
  onValueChange: T,
  onOptionSelect: y,
  onOptionDeselect: O,
  search: R = !1,
  searchLabel: $ = "Search...",
  autoSelect: F = !1,
  noResultsText: K = "No results",
  preventFirstSelection: S = !1,
  value: j,
  tag: M = "div",
  theme: N,
  container: D,
  clearIcon: B,
  selectIcon: W,
  ...z
}) => {
  const [X, G] = E(!1), [J, q] = E(e), [te, Q] = E(!1), [I, le] = E(!1), [ce, Ce] = E("0px"), [ye, ve] = E(0), [Ie, he] = E(null), [Te, A] = E(""), [V, se] = E(""), [re, pe] = E(() => d ? ke : t.findIndex((L) => !L.disabled)), [ee, fe] = E([]), [H, at] = E([]), [ae, it] = E(), [Le, lt] = E(), qe = P(null), Ye = P(null), Ke = P(null), ct = P(null), xe = Ae(
    () => H.filter(
      (L) => {
        var _;
        return ((_ = L.text) == null ? void 0 : _.toLocaleLowerCase().includes(V.toLocaleLowerCase())) || L.optgroup;
      }
    ),
    [V, H]
  ), ie = {
    ...ar,
    ...N
  }, dt = U("relative", i), ut = U(
    ie.dropdown,
    J ? ie.dropdownVisible : ie.dropdownHidden
  ), ft = U(
    ie.optionsWrapper,
    ie.optionsWrapperScrollbar
  ), pt = U(
    ie.selectArrow,
    g && ie.selectArrowWhite,
    !p && ie.selectArrowDefault,
    p === "sm" && ie.selectArrowSm,
    p === "lg" && ie.selectArrowLg,
    document.activeElement === ae ? g ? ie.selectArrowWhiteFocused : ie.selectArrowFocused : null
  ), bt = U(
    ie.selectClearBtn,
    g && ie.selectClearBtnWhite,
    !p && ie.selectClearBtnDefault,
    p === "sm" && ie.selectClearBtnSm,
    p === "lg" && ie.selectClearBtnLg
  ), { styles: mt, attributes: ht } = Oe(ae, Le, {
    placement: "bottom-start"
  }), Ne = oe(() => {
    J && Ce(`${ae == null ? void 0 : ae.offsetWidth}px`);
  }, [ae, J]), Ge = (L) => {
    if (H.length === 0)
      return;
    const _ = Ye.current, Y = _.offsetHeight, Z = _.scrollTop, ge = H.filter(
      (de) => de.hidden && de.elementPosition < L
    ).length, Re = a && d ? L + 1 : L;
    if (L > (a && d ? -2 : -1)) {
      const de = (Re - ge) * l, yt = de + l > Z + Y;
      de < Z ? _.scrollTop = de : yt ? _.scrollTop = de - Y + l : _.scrollTop = Z;
    }
  }, { onTransitionShow: gt, onTransitionHide: vt } = we(
    Ke.current
  ), xt = () => {
    const L = (Y) => xe.findIndex(
      (Z) => Z.elementPosition == Y
    );
    let _ = re;
    for (; _ < H.length - 1; ) {
      if (_++, a && _ === ke)
        return ke;
      const Y = L(_) != -1, Z = H[_].disabled || H[_].hidden, ge = xe[L(_ - 1)] === xe[xe.length - 1];
      if (_ === H.length && (!Y || Z) || ge)
        return re;
      if (Y && !Z)
        break;
    }
    return _;
  }, wt = () => {
    let L = re;
    for (; L >= 0; ) {
      L -= 1;
      const _ = xe.findIndex((Z) => Z.elementPosition == L) != -1, Y = L >= 0 && (H[L].disabled || H[L].hidden);
      if (L <= 0 && (!_ || Y))
        return a && d ? L = -1 : re;
      if (_ && !Y)
        break;
    }
    return L;
  }, Ue = (L) => {
    const { key: _ } = L;
    if ([Fe, $e, Ve, et, He].includes(_)) {
      if (_ === et)
        return F && Me(xe[re]), ae == null || ae.focus(), le(!1);
      if (L.preventDefault(), L.altKey && _ === $e || L.altKey && _ === Fe)
        return le(!I);
      if (_ === $e) {
        const Y = xt();
        return I ? (Ge(Y), pe(Y)) : a ? le(!0) : fe([Y]);
      }
      if (_ === Fe) {
        const Y = wt();
        return I ? (Ge(Y), pe(Y)) : a ? le(!0) : fe([Y]);
      }
      if (_ === Ve) {
        const Y = xe.findIndex(
          (Z) => Z.elementPosition == re
        );
        return I ? re === ke ? Qe() : Me(xe[Y]) : le(!0);
      }
      if (_ === He)
        return le(!1), ae == null ? void 0 : ae.focus();
    }
  }, Se = oe(() => {
    le((L) => !L);
  }, []), Be = oe(
    (L) => {
      if (h && h.current === L.target)
        return;
      const _ = Le && Le !== null, Y = ae && ae !== null, Z = !(Le != null && Le.contains(L.target)) && !(ae != null && ae.contains(L.target)), ge = L.target === ct.current;
      _ && I && Y && Z && !ge && le(!1);
    },
    [Le, ae, I, h]
  );
  C(() => {
    const L = t.map((_, Y) => ({ ..._, elementPosition: Y }));
    cr(L, H) || at(L);
  }, [t, H]);
  const Qe = () => {
    if (!a || !d)
      return;
    if (ee.length === t.filter((_) => !_.disabled && !_.optgroup).length)
      return fe([]), T == null || T([]), _e([]);
    const L = H == null ? void 0 : H.filter((_) => !_.disabled && !_.optgroup).map((_) => _.elementPosition);
    return fe(L), T == null || T(t.filter((_) => !_.disabled)), _e(L);
  }, De = oe(() => {
    if (H.length === 0)
      return;
    let L = ee[0];
    const _ = L === void 0;
    if (te && !a) {
      if (_ && S || !te || a)
        return;
      _ && (L = 0);
      const Y = H[L].value, Z = String(H[L].text);
      Z ? (he(Y ? null : Z), A(Y ? Z : "")) : (he(null), A(Y ? " " : ""));
    }
  }, [
    a,
    te,
    ee,
    H,
    S
  ]), _e = oe(
    (L) => {
      const _ = u === -1 || L.length > u;
      if (L.length <= 0 && (he(null), A("")), _)
        return he(null), A(`${L.length} ${x}`);
      const Y = L.map((de) => H[de].text || "").filter((de) => de !== ""), Z = L.map((de) => H[de].value || "").filter((de) => de !== ""), ge = Y.findIndex((de) => de !== "") === -1, Re = Z.length > 0, ze = Y.join(", ");
      ge ? (he(null), A(Re ? " " : "")) : Re ? (A(ze), he(null)) : (A(""), he(ze));
    },
    [u, x, H]
  );
  C(() => {
    De();
  }, [ee, De]);
  const Me = (L) => {
    if (!L || L.disabled)
      return;
    const { elementPosition: _ } = L;
    if (a) {
      const Y = ee.includes(_);
      Y ? O == null || O(t[_]) : y == null || y(t[_]);
      const Z = Y ? ee.filter(
        (ge) => ge !== _
      ) : [...ee, _];
      return fe(Z), pe(_), T == null || T(Z.map((ge) => t[ge])), _e(Z);
    }
    return O == null || O(t[re]), fe([_]), T == null || T(t[_]), y == null || y(t[_]), le(!1), ae == null ? void 0 : ae.focus();
  };
  C(() => {
    Q(!0);
  }, []), C(() => {
    if (a) {
      const _ = H.filter((Y) => Y.defaultSelected).map((Y) => Y.elementPosition);
      return _e(_), fe(_);
    }
    let L = H.findIndex((_) => _.defaultSelected);
    L === ke && !S && (L = H.findIndex((_) => !_.disabled && !_.hidden)), L !== ke && fe([L]);
  }, [H, _e, a, S]), C(() => {
    if (I && R && ee.length === 0)
      return pe(ke);
    I || (ee.length > 0 ? pe(Math.max(...ee)) : pe(a ? ke - 1 : 0));
  }, [xe, I, R, ee, ee]), C(() => {
    ve(o * l);
  }, [o, l]), C(() => {
    Ne();
  }, [Ne]), C(() => (I && (window.addEventListener("click", Be), window.addEventListener("resize", Ne)), () => {
    window.removeEventListener("click", Be), window.removeEventListener("resize", Ne);
  }), [Be, Ne, I]), C(() => {
    if (h) {
      const L = h.current;
      return L == null || L.addEventListener("click", Se), () => {
        L == null || L.removeEventListener("click", Se);
      };
    }
  }, [h, Se]), C(() => {
    if (!j)
      return;
    const L = Array.isArray(j) ? j : [j], _ = H.filter((Z) => Z.value && L.includes(Z.value)).map((Z) => Z.elementPosition);
    if (_.toString() === ee.toString())
      return;
    const Y = a ? _.map((Z) => H[Z]) : H[_[0]];
    T == null || T(Y), fe(_), a ? _e(_) : De();
  }, [
    j,
    H,
    a,
    T,
    ee,
    De,
    _e
  ]), C(() => {
    le(e);
  }, [e]), C(() => {
    if (I) {
      G(!0), gt(() => {
        q(!0), r == null || r(!0);
      });
      return;
    }
    J && (q(!1), r == null || r(!1), document.activeElement === ae && ae.blur(), vt(() => {
      G(!1), R && se("");
    }));
  }, [I]), C(() => {
    var L;
    X && (J ? b == null || b() : w == null || w(), J && R && ((L = qe.current) == null || L.focus()));
  }, [J]);
  const kt = D && document.querySelector(D) || document.body;
  return /* @__PURE__ */ v(be, { children: /* @__PURE__ */ ne(M, { className: dt, ...z, children: [
    /* @__PURE__ */ v(
      jt,
      {
        type: "text",
        ref: it,
        onClick: () => le(!I),
        onKeyDown: Ue,
        value: Te,
        disabled: c,
        placeholder: String(Te) || s ? void 0 : f,
        label: s,
        readOnly: !0,
        size: p,
        theme: { input: ie.selectInput, label: ie.selectLabel },
        formWhite: g,
        "aria-multiselectable": !!a,
        "aria-disabled": !!c,
        "aria-expanded": I,
        role: "listbox"
      }
    ),
    n && (Te.length > 0 || Ie) && /* @__PURE__ */ v(
      "span",
      {
        tabIndex: 0,
        className: bt,
        role: "button",
        onClick: () => {
          A(""), fe([]), T == null || T(a ? [] : {});
        },
        children: B || /* @__PURE__ */ v(
          "svg",
          {
            xmlns: "http://www.w3.org/2000/svg",
            fill: "none",
            viewBox: "0 0 24 24",
            strokeWidth: "1.5",
            stroke: "currentColor",
            children: /* @__PURE__ */ v(
              "path",
              {
                strokeLinecap: "round",
                strokeLinejoin: "round",
                d: "M6 18L18 6M6 6l12 12"
              }
            )
          }
        )
      }
    ),
    /* @__PURE__ */ v("div", { className: pt, children: W || /* @__PURE__ */ v(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: "1.5",
        stroke: "currentColor",
        children: /* @__PURE__ */ v(
          "path",
          {
            strokeLinecap: "round",
            strokeLinejoin: "round",
            d: "M19.5 8.25l-7.5 7.5-7.5-7.5"
          }
        )
      }
    ) }),
    X && tt(
      /* @__PURE__ */ v(
        "div",
        {
          ref: lt,
          style: { ...mt.popper, width: ce },
          ...ht.popper,
          className: ie.selectDropdownContainer,
          children: /* @__PURE__ */ ne("div", { tabIndex: 0, className: ut, ref: Ke, children: [
            R && /* @__PURE__ */ v("div", { className: ie.inputGroup, children: /* @__PURE__ */ v(
              "input",
              {
                className: ie.selectFilterInput,
                placeholder: $,
                onKeyDown: Ue,
                onChange: (L) => se(L.target.value),
                ref: qe,
                type: "text",
                role: "searchbox"
              }
            ) }),
            /* @__PURE__ */ v(
              "div",
              {
                className: ft,
                ref: Ye,
                style: { maxHeight: `${ye}px` },
                children: /* @__PURE__ */ v(
                  lr,
                  {
                    data: t,
                    selectData: xe,
                    selectedElements: ee,
                    optionHeight: l,
                    visibleOptions: o,
                    handleOptionClick: Me,
                    handleSelectAll: Qe,
                    selectAll: d,
                    selectAllLabel: k,
                    multiple: a,
                    activeElementIndex: re,
                    search: R,
                    noResultsText: K,
                    theme: ie
                  }
                )
              }
            ),
            m
          ] })
        }
      ),
      kt
    )
  ] }) });
}, dr = (e) => e.offsetHeight, ur = (e) => {
  if (!e || e.getClientRects().length === 0)
    return !1;
  if (e instanceof HTMLElement && e.style && e.parentNode && e.parentNode instanceof HTMLElement && e.parentNode.style) {
    const r = getComputedStyle(e), t = getComputedStyle(e.parentNode);
    return getComputedStyle(e).getPropertyValue("visibility") === "visible" || r.display !== "none" && t.display !== "none" && r.visibility !== "hidden";
  }
  return !1;
}, st = je({
  activeSlide: 0,
  setTransitionDuration: () => {
  },
  block: "",
  visible: "",
  crossfade: void 0,
  setCarouselItems: () => {
  },
  isFirstRender: { current: !0 }
}), fr = {
  carouselWrapper: "relative",
  pointer: "touch-pan-y",
  block: "!block",
  visible: "opacity-100 !z-10",
  invisible: "opacity-0 z-0",
  slideRight: "translate-x-full",
  slideLeft: "-translate-x-full",
  nextBtn: "absolute bottom-0 right-0 top-0 z-30 flex w-[15%] items-center justify-center border-0 bg-none p-0 text-center text-white opacity-50 transition-opacity duration-150 ease-[cubic-bezier(0.25,0.1,0.25,1.0)] hover:text-white hover:no-underline hover:opacity-90 hover:outline-none focus:text-white focus:no-underline focus:opacity-90 focus:outline-none motion-reduce:transition-none",
  nextBtnIcon: "inline-block h-8 w-8 [&>svg]:h-8",
  prevBtn: "absolute bottom-0 left-0 top-0 z-30 flex w-[15%] items-center justify-center border-0 bg-none p-0 text-center text-white opacity-50 transition-opacity duration-150 ease-[cubic-bezier(0.25,0.1,0.25,1.0)] hover:text-white hover:no-underline hover:opacity-90 hover:outline-none focus:text-white focus:no-underline focus:opacity-90 focus:outline-none motion-reduce:transition-none",
  prevBtnIcon: "inline-block h-8 w-8 [&>svg]:h-8",
  indicatorsWrapper: "absolute bottom-0 left-0 right-0 z-30 mx-[15%] mb-4 flex list-none justify-center p-0",
  indicator: "mx-[3px] box-content h-[3px] w-[30px] flex-initial cursor-pointer border-0 border-y-[10px] border-solid border-transparent bg-white bg-clip-padding p-0 -indent-[999px] opacity-50 transition-opacity duration-[600ms] ease-[cubic-bezier(0.25,0.1,0.25,1.0)] motion-reduce:transition-none focus:outline-none",
  activeIndicator: "!opacity-100"
}, Kr = ({
  tag: e = "div",
  className: r,
  children: t,
  interval: i = 5e3,
  ride: l = !1,
  keyboard: o = !0,
  pause: c = "hover",
  wrap: f = !0,
  touch: s = !0,
  stopSliding: n,
  showControls: m,
  showIndicators: a,
  prevBtnIcon: u,
  nextBtnIcon: x,
  current: d,
  crossfade: k,
  onSlide: p,
  onSlid: h,
  theme: g,
  ...b
}) => {
  const [w, T] = E(0), [y, O] = E(0), [R, $] = E(
    document.visibilityState
  ), [F, K] = E({ initialX: 0, initialY: 0 }), [S, j] = E([]), M = P(null), N = P(0), D = P(!0), B = P(!1), W = P(!0), z = P(!1), X = P(!1), G = P(null), J = P(null), q = {
    ...fr,
    ...g
  }, te = U(
    q.carouselWrapper,
    s && q.pointer,
    r
  ), Q = (A, V) => {
    if (V !== void 0)
      return S[V];
    const se = A === "prev", re = N.current, pe = se ? -1 : 1;
    let ee = re;
    if (f)
      ee = (re + pe) % S.length;
    else {
      if (ee === S.length - 1 && A === "next" || ee === 0 && A === "prev")
        return;
      ee += pe;
    }
    return ee === -1 ? S[S.length - 1] : S[ee];
  }, I = (A, V) => {
    if (V !== void 0) {
      N.current = V, T(V);
      return;
    }
    const se = w === S.length - 1 ? 0 : w + 1, re = w === 0 ? S.length - 1 : w - 1;
    N.current = A === "next" ? se : re, T(A === "next" ? se : re);
  }, le = oe(
    (A, V, se) => {
      if (!S || S.length < 2 || B.current)
        return;
      W.current && (W.current = !1);
      const re = S[w];
      if (!re || !V)
        return;
      B.current = !0, p == null || p();
      const pe = A === "next", ee = pe ? q.slideLeft : q.slideRight, fe = pe ? q.slideRight : q.slideLeft;
      I(A, se), V.classList.add(fe, q.block), dr(V), re.classList.add(ee), k && (re.classList.add(...q.invisible.split(" ")), re.classList.remove(...q.visible.split(" ")), V.classList.add(...q.visible.split(" "))), V.classList.remove(fe), J.current !== null && clearTimeout(J.current), J.current = setTimeout(() => {
        B.current = !1, h == null || h(), re.classList.remove(ee, q.block);
      }, y);
    },
    [w, y, k]
  ), ce = oe(
    (A) => {
      const V = Q(A), { hidden: se } = document;
      if (R && (se || !ur(M.current))) {
        z.current = !0;
        return;
      }
      V && le(A, V);
    },
    [le, R]
  ), Ce = (A) => {
    const V = N.current, se = A > V ? "next" : "prev", re = Q(se, A);
    !re || A > S.length - 1 || A < 0 || A === w || le(se, re, A);
  }, ye = oe(() => {
    typeof i == "number" && i > 0 && (X.current && (X.current = !1), G.current = setTimeout(() => {
      ce("next");
    }, i));
  }, [ce, i]), ve = () => {
    G.current && (clearTimeout(G.current), G.current = null);
  }, Ie = oe((A) => {
    K({
      initialX: A.touches[0].clientX,
      initialY: A.touches[0].clientY
    });
  }, []), he = oe(
    (A) => {
      if (!F)
        return;
      const { initialX: V, initialY: se } = F, re = A.touches[0].clientX, pe = A.touches[0].clientY, ee = V - re, fe = se - pe;
      Math.abs(ee) > Math.abs(fe) && (ee > 0 ? ce("next") : ce("prev")), K({ initialX: 0, initialY: 0 });
    },
    [ce, F]
  ), Te = oe(
    (A) => {
      switch (A.key) {
        case "ArrowLeft":
          A.preventDefault(), ce("prev");
          break;
        case "ArrowRight":
          A.preventDefault(), ce("next");
          break;
      }
    },
    [ce]
  );
  return C(() => {
    const A = () => {
      $(document.visibilityState);
    };
    return document.addEventListener("visibilitychange", A), () => {
      document.removeEventListener("visibilitychange", A);
    };
  }, [i, l]), C(() => {
    if (!o || !M.current)
      return;
    const A = M.current;
    return A.addEventListener("keydown", Te), () => {
      A.removeEventListener("keydown", Te);
    };
  }, [o, Te]), C(() => {
    if (!s || !M.current)
      return;
    const A = M.current;
    return A.addEventListener("touchmove", he), A.addEventListener("touchstart", Ie), () => {
      A.removeEventListener("touchmove", he), A.removeEventListener("touchstart", Ie);
    };
  }, [s, he, Ie]), C(() => {
    if (!l || l === !0 && W.current || !c || !M.current)
      return;
    const A = () => {
      ve(), X.current = !0;
    }, V = () => {
      n || ye();
    }, se = M.current;
    return se.addEventListener("mouseenter", A), se.addEventListener("mouseleave", V), se.addEventListener("touchend", ve), () => {
      se.removeEventListener("mouseenter", A), se.removeEventListener("mouseleave", V), se.removeEventListener("touchend", ve);
    };
  }, [c, l, ye]), C(() => {
    if (D.current) {
      D.current = !1;
      return;
    }
    if (!(!S || S.length < 2) && !(n || l === !0 && W.current || !l || R === "hidden" || !i || X.current)) {
      if (z.current && R === "visible") {
        ce("next"), z.current = !1;
        return;
      }
      return ye(), () => {
        ve();
      };
    }
  }, [
    w,
    i,
    l,
    y,
    R,
    n
  ]), C(() => {
    D.current || (n && !W.current && ve(), d !== void 0 && Ce(d));
  }, [n, d]), /* @__PURE__ */ v(
    st.Provider,
    {
      value: {
        activeSlide: w,
        setTransitionDuration: O,
        block: q.block,
        visible: q.visible,
        crossfade: k,
        setCarouselItems: j,
        isFirstRender: D
      },
      children: /* @__PURE__ */ ne(
        e,
        {
          ref: M,
          className: te,
          current: w,
          ...b,
          children: [
            t,
            m && /* @__PURE__ */ ne(be, { children: [
              /* @__PURE__ */ ne(
                "button",
                {
                  onClick: () => ce("prev"),
                  className: q.prevBtn,
                  type: "button",
                  children: [
                    /* @__PURE__ */ v("span", { className: q.prevBtnIcon, children: u || /* @__PURE__ */ v(
                      "svg",
                      {
                        xmlns: "http://www.w3.org/2000/svg",
                        fill: "none",
                        viewBox: "0 0 24 24",
                        strokeWidth: "1.5",
                        stroke: "currentColor",
                        children: /* @__PURE__ */ v(
                          "path",
                          {
                            strokeLinecap: "round",
                            strokeLinejoin: "round",
                            d: "M15.75 19.5L8.25 12l7.5-7.5"
                          }
                        )
                      }
                    ) }),
                    /* @__PURE__ */ v("span", { className: "!absolute !-m-px !h-px !w-px !overflow-hidden !whitespace-nowrap !border-0 !p-0 ![clip:rect(0,0,0,0)]", children: "Previous" })
                  ]
                }
              ),
              /* @__PURE__ */ ne(
                "button",
                {
                  onClick: () => ce("next"),
                  className: q.nextBtn,
                  type: "button",
                  children: [
                    /* @__PURE__ */ v("span", { className: q.nextBtnIcon, children: x || /* @__PURE__ */ v(
                      "svg",
                      {
                        xmlns: "http://www.w3.org/2000/svg",
                        fill: "none",
                        viewBox: "0 0 24 24",
                        strokeWidth: "1.5",
                        stroke: "currentColor",
                        children: /* @__PURE__ */ v(
                          "path",
                          {
                            strokeLinecap: "round",
                            strokeLinejoin: "round",
                            d: "M8.25 4.5l7.5 7.5-7.5 7.5"
                          }
                        )
                      }
                    ) }),
                    /* @__PURE__ */ v("span", { className: "!absolute !-m-px !h-px !w-px !overflow-hidden !whitespace-nowrap !border-0 !p-0 ![clip:rect(0,0,0,0)]", children: "Next" })
                  ]
                }
              )
            ] }),
            a && /* @__PURE__ */ v("div", { className: q.indicatorsWrapper, children: S.map((A, V) => /* @__PURE__ */ v(
              "button",
              {
                "data-te-target": V,
                onClick: () => Ce(V),
                className: `${q.indicator} ${V === w ? `${q.activeIndicator}` : ""}`
              },
              V
            )) })
          ]
        }
      )
    }
  );
}, Gr = ({
  tag: e = "div",
  className: r,
  itemID: t,
  children: i,
  ...l
}) => {
  const o = P(null), {
    activeSlide: c,
    setTransitionDuration: f,
    block: s,
    visible: n,
    crossfade: m,
    setCarouselItems: a,
    isFirstRender: u
  } = me(st), { transitionDuration: x } = we(
    o.current,
    r
  );
  return C(() => {
    if (u != null && u.current) {
      a((d) => [
        ...d,
        o.current
      ]);
      return;
    }
  }, []), C(() => {
    if (c === t - 1) {
      const d = o.current;
      d.classList.add(s), m && d.classList.add(...n.split(" ")), f(x);
    }
  }, [c, t, m, x]), /* @__PURE__ */ v(e, { ref: o, className: r, ...l, children: i });
};
export {
  Xr as TEAlert,
  Ar as TEAnimation,
  Kr as TECarousel,
  Gr as TECarouselItem,
  Fr as TEChart,
  wr as TECollapse,
  Sr as TEDropdown,
  zr as TEDropdownItem,
  Mr as TEDropdownMenu,
  Br as TEDropdownToggle,
  jt as TEInput,
  yr as TEModal,
  Cr as TEModalBody,
  Lr as TEModalContent,
  Tr as TEModalDialog,
  Er as TEModalFooter,
  _r as TEModalHeader,
  Pr as TEPopover,
  Wr as TEPopoverContent,
  Or as TEPopoverToggler,
  kr as TERipple,
  Yr as TESelect,
  Ir as TETabs,
  Dr as TETabsContent,
  Nr as TETabsItem,
  Rr as TETabsPane,
  jr as TETextarea,
  qr as TEToast,
  $r as TETooltip
};
//# sourceMappingURL=tw-elements-react.es.min.js.map
