/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.spooferbt.server;

import com.martijncourteaux.spooferbt.common.Peer;
import com.martijncourteaux.spooferbt.common.Utils;
import com.martijncourteaux.spooferbt.server.Tracker;
import com.martijncourteaux.spooferbt.server.TrackerAnnounceRequest;
import com.martijncourteaux.spooferbt.server.TrackerAnnounceResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.Arrays;
import java.util.Random;

public class UDPTracker
extends Tracker {
    private String host;
    private int port;
    private InetSocketAddress address;
    private DatagramSocket socket;
    private long connection_timestamp;
    private long current_connection_id;
    private int current_transaction_id;

    public UDPTracker(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
        if (this.address.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        this.socket = new DatagramSocket();
        this.socket.connect(this.address);
        this.socket.setSoTimeout(7500);
        System.out.println("Datagram socket created at port: " + this.socket.getLocalPort());
    }

    private boolean isConnectionValid() {
        long now = System.currentTimeMillis();
        return now < this.connection_timestamp + 60000L;
    }

    private void requestConnectionID() throws IOException {
        System.out.println("Requesting new connection ID...");
        int transaction_id = new Random().nextInt();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(4497486125440L);
        dos.writeInt(0);
        dos.writeInt(transaction_id);
        dos.close();
        DatagramPacket packet = new DatagramPacket(baos.toByteArray(), baos.size(), this.address);
        DatagramPacket response = new DatagramPacket(new byte[16], 16);
        this.socket.send(packet);
        this.socket.receive(response);
        System.out.println("Tracker responded from UDP port: " + response.getPort());
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(response.getData()));
        int response_action = dis.readInt();
        int response_transaction_id = dis.readInt();
        long response_connection_id = dis.readLong();
        if (response_transaction_id != transaction_id) {
            System.out.println("invalid response transaction id!");
        } else if (response_action != 0) {
            System.out.println("invalid response action!");
        } else {
            this.connection_timestamp = System.currentTimeMillis();
            this.current_connection_id = response_connection_id;
            this.current_transaction_id = response_transaction_id;
        }
    }

    @Override
    public TrackerAnnounceResponse request(TrackerAnnounceRequest tr) throws Exception {
        if (!this.isConnectionValid()) {
            this.requestConnectionID();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(this.current_connection_id);
        dos.writeInt(1);
        dos.writeInt(this.current_transaction_id);
        dos.write(Utils.encodeInfoHash(tr.info_hash));
        dos.write(Utils.getPaddedBytes(tr.peer_id, 20));
        dos.writeLong(tr.downloaded);
        dos.writeLong(tr.left);
        dos.writeLong(tr.uploaded);
        dos.writeInt(Event.valueOf(tr.event.toUpperCase()).ordinal());
        dos.write(InetAddress.getByName(tr.ip).getAddress());
        dos.writeInt(0);
        dos.writeInt(tr.numwant);
        dos.writeShort(tr.port);
        dos.close();
        this.socket.setSoTimeout(5000);
        DatagramPacket packet = new DatagramPacket(baos.toByteArray(), baos.size(), this.address);
        DatagramPacket response = new DatagramPacket(new byte[200], 200);
        this.socket.send(packet);
        System.out.println("Announce sent...");
        System.out.println("Waiting for response...");
        this.socket.receive(response);
        System.out.println("Got response! " + response.getLength());
        TrackerAnnounceResponse tres = new TrackerAnnounceResponse();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(response.getData(), 0, response.getLength()));
        tres.action = dis.readInt();
        tres.transaction_id = dis.readInt();
        tres.interval = dis.readInt();
        tres.leechers = dis.readInt();
        tres.seeders = dis.readInt();
        int response_peer_count = (response.getLength() - 20) / 6;
        int i = 0;
        while (i < response_peer_count) {
            byte[] ipAddress = new byte[4];
            dis.read(ipAddress);
            short port = dis.readShort();
            tres.peers.add(new Peer(ipAddress, port));
            ++i;
        }
        return tres;
    }

    public byte[] forwardPacket(byte[] buffer, int offset, int length) throws IOException {
        DatagramPacket packet = new DatagramPacket(buffer, offset, length, this.address);
        DatagramPacket response = new DatagramPacket(new byte[1024], 1024);
        this.socket.send(packet);
        this.socket.receive(response);
        this.socket.close();
        return Arrays.copyOfRange(response.getData(), response.getOffset(), response.getLength());
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        this.socket.disconnect();
        this.socket.close();
    }

    private static enum Event {
        NONE,
        COMPLETED,
        STARTED,
        STOPPED;

    }
}

