/*
 * Decompiled with CFR 0.152.
 */
package com.martijncourteaux.spooferbt.argumentsparser;

import com.martijncourteaux.spooferbt.argumentsparser.Argument;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ArgumentParser {
    private String usage;
    private Map<String, Argument> args = new HashMap<String, Argument>();

    public void addArgument(String name, Class<?> valueType, Object defaultValue) {
        Argument arg = new Argument();
        arg.name = name;
        arg.valueType = valueType;
        arg.value = defaultValue;
        arg.defaultValue = defaultValue;
        this.args.put(name, arg);
    }

    public void parse(String[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            String argName = arguments[i];
            Argument arg = this.args.get(argName);
            if (arg == null) {
                System.out.println("Unknown argument: " + argName);
                this.usage();
                System.exit(0);
            }
            arg.present = true;
            if (arg.valueType != null) {
                String value = arguments[++i];
                arg.setValue(value);
            }
            ++i;
        }
    }

    public <T> T getOrUsage(String name, Class<T> type) {
        Argument a = this.args.get(name);
        if (a == null) {
            System.out.println("No argument named: " + name + " found!");
            System.exit(1);
        }
        if (a.valueType != type) {
            return null;
        }
        if (a.present) {
            return (T)a.value;
        }
        if (a.defaultValue != null) {
            return (T)a.defaultValue;
        }
        System.out.println("Argument not found! " + name);
        this.usage();
        System.exit(0);
        return null;
    }

    public boolean isPresent(String name) {
        Argument a = this.args.get(name);
        if (a == null) {
            System.out.println("No argument named: " + name + " found!");
            System.exit(1);
        }
        return a.present;
    }

    public void usage() {
        System.out.println(this.usage);
    }

    public int oneOfTheseOrUsage(String ... names) {
        int found = -1;
        int i = 0;
        while (i < names.length) {
            if (this.isPresent(names[i])) {
                if (found != -1) {
                    found = -1;
                    break;
                }
                found = i;
            }
            ++i;
        }
        if (found == -1) {
            System.out.println("None of these found: " + Arrays.toString(names));
            this.usage();
            System.exit(0);
        }
        return found;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public int oneOfTheseOr(int defaultOption, String ... names) {
        int i = 0;
        while (i < names.length) {
            if (this.isPresent(names[i])) {
                return i;
            }
            ++i;
        }
        return defaultOption;
    }
}

