# Awesome LoRa and LoRaWAN

  <a href="https://www.linkedin.com/in/mauro-cicolella-0b107076/"><img src="https://img.shields.io/badge/linkedin-%230077B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white" height=25></a>
    <a href="https://twitter.com/emmecilab"><img src="https://img.shields.io/badge/twitter-%231DA1F2.svg?&style=for-the-badge&logo=twitter&logoColor=white" height=25></a>
  <a href="https://www.youtube.com/c/emmecilab"><img src="https://img.shields.io/badge/youtube-%23E4405F.svg?&style=for-the-badge&logo=youtube&logoColor=white" height=25></a>

> A curated list of LoRa and LoRaWAN resources.

**Check out my [Twitter account](https://twitter.com/emmecilab) or [blog](https://www.emmecilab.net) and subscribe my [YouTube channel](https://youtube.com/c/emmecilab)**

### Contents

- [Communities](#communities)
- [Libraries](#libraries)
- [LoRaWAN Servers](#lorawan-servers)
- [Master Thesis](#master-thesis)
- [Presentations](#presentations)
- [Products](#products)
- [Tools](#tools)
- [Troubleshooting](#troubleshooting)
- [Tutorials](#tutorials)
- [Videos](#videos)


## Communities

- [OpenLora](https://openlora.com/forum/)
- [The Things Network](https://www.thethingsnetwork.org/forum/)


## Libraries

- [Arduino example sketches](https://github.com/CongducPham/LowCostLoRaGw/tree/master/Arduino#arduino-example-sketches) - The example sketches, in increasing level of complexity, will show how simple, yet effective, low-cost LoRa IoT device can be programmed.
- [Arduino-LMIC library](https://github.com/mcci-catena/arduino-lmic) - This repository contains the IBM LMIC (LoraMAC-in-C) library, slightly modified to run in the Arduino environment, allowing using the SX1272, SX1276 transceivers and compatible modules (such as some HopeRF RFM9x modules and the Murata LoRa modules).
- [DeviceHive LoRa gateway](https://github.com/devicehive/lora-gateway) - This project implements LoRa gateway using DeviceHive cloud service.
- [LoRaArduino](https://github.com/lupyuen/LoRaArduino) - Arduino code for connecting to LoRa IoT gateway at Temasek Polytechnic. 
- [LoRa Python library](https://github.com/mayeranalytics/pySX127x) -  Python interface to the Semtech SX1276/7/8/9.
- [RadioHead](https://www.airspayce.com/mikem/arduino/RadioHead/) - It provides a complete object-oriented library for sending and receiving packetized messages via a variety of common data radios and other transports on a range of embedded microprocessors.
- [RadioLib](https://github.com/jgromes/RadioLib) - Universal wireless communication library for embedded devices. LoRaWAN implementation for SX127x, RFM9x, SX126x, LR11x0 and SX128x.


## LoRaWAN Servers

- [Compact server for private LoRaWAN networks](https://github.com/gotthardp/lorawan-server) - Open-source LoRaWAN Server that integrates both the network-server and the application-server.
- [ChirpStack (former LoRa Server)](https://www.chirpstack.io/) - Open-source LoRaWAN network-server.


## Master Thesis

- [Development of an open-source gateway and network server for "Internet of Things" communications based on LoRaWAN technology](http://vlsi.diet.uniroma1.it/downloads/Thesis_Allahparast.pdf) - Soroush Allahparast, Università di Roma "La Sapienza", 2018 (PDF).
- [LoRaWAN Gateway and IoT Low-Cost Mote Prototype](http://wpd.ugr.es/~jorgenavarro/thesis/2017_TFG_AngelGuzmanMartinez.pdf) -  Angel Guzman-Martinez, School of Informatics and Telecommunications Engineering Granada, 2017 (PDF).


## Presentations

[IoT Comunitaria - partecipa alla rete (Italian)](https://merge-it.net/talks/iot-comunitaria/slides.pdf) - Nino Ciurleo - Merge-IT Torino, 2018 (PDF).


## Products

- [Dragino LoRa Wireless Mote , Gateway](http://www.dragino.com/products/lora.html)
- [ESP-1ch-Gateway](https://github.com/hallard/ESP-1ch-Gateway)
- [iC880A - LoRaWAN® Concentrator 868MHz](https://wireless-solutions.de/products/radiomodules/ic880a.html)
- [Heltec CubeCell Series](https://heltec.org/proudct_center/lora/cubecell/)
- [Mini Lora Node, Arduino Mini LoraWAN sensor](https://github.com/hallard/Mini-LoRa)
- [Pycom LoPy](https://pycom.io/product/lopy4-multipack/)


## Tools

- [LoRaWAN node simulator](https://github.com/kartben/lorawan-node-simulator)


## Troubleshooting

- [TTN  DRAGINO problems and solutions topic part 1](https://www.thethingsnetwork.org/forum/t/dragino-problems-and-solutions-topic-part-1/8951)
- [TTN  DRAGINO problems and solutions topic part 2](https://www.thethingsnetwork.org/forum/t/dragino-problems-and-solutions-topic-part-2/19143)


## Tutorials

- [A DIY low-cost LoRa gateway](http://cpham.perso.univ-pau.fr/LORA/RPIgateway.html)
- [Building a Raspberry Pi Powered LoRaWAN Gateway](https://www.rs-online.com/designspark/building-a-raspberry-pi-powered-lorawan-gateway) - Using a Raspberry Pi 2 + iC880A to build the first gateway for Things Network Calderdale.
- [Building a private LoRa network](https://os.mbed.com/docs/latest/tutorials/LoRa-tutorial.html)
- [Dragino LoRa shield](http://wiki.dragino.com/index.php?title=Lora_Shield) - Wiki of Dragino LoRa shield.
- [From zero to LoRaWAN in a weekend](https://github.com/ttn-zh/ic880a-gateway/wiki) - Reference setup for The Things Network gateways based on the iC880a USB concentrator with a Raspberry Pi host.
- [LoPy LoRaWAN Nano-Gateway Using MicroPython and TTN](https://www.hackster.io/bucknalla/lopy-lorawan-nano-gateway-using-micropython-and-ttn-a9fb19) - Can't afford an expensive LoRa gateway to test your projects? Use a Pycom LoPy as a nano-gateway and connect up to The Things Network!
- [Low-cost LoRa IoT framework developed in the EU H2020 WAZIUP/WAZIHUB projects](https://github.com/CongducPham/LowCostLoRaGw#connect-a-radio-module-to-your-end-device)
- [MAKE your own 200€ LoRa gateway](https://github.com/mirakonta/lora_gateway/wiki)
- [MoRa](https://github.com/DaveCalaway/MoRa/wiki)
- [Setting up a The Things Network gateway](https://oisec.net/blog/ttn-gateway-rak831-ic880a) 
- [Use Lora Shield and RPi to Build a LoRaWAN Gateway](https://www.instructables.com/id/Use-Lora-Shield-and-RPi-to-Build-a-LoRaWAN-Gateway/) 


## Videos

- [LoRa](https://www.youtube.com/playlist?list=PL3XBzmAj53Rkkogh-lti58h_GkhzU1n7U) - Many interesting video tutorials about LoRa with Dragino, Raspberry Pi, ESP32 and so on.
- [LoRa/LoRaWAN tutorials](https://www.youtube.com/playlist?list=PLmL13yqb6OxdeOi97EvI8QeO8o-PqeQ0g) - These video tutorials cover a variety of different topics which will help you to understand LoRa/LoRaWAN.


## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)


## Contributing

Please, read the [Contribution Guidelines](https://github.com/mcicolella/lora-lorawan/blob/master/contributing.md) before submitting your suggestion.

Feel free to [open an issue](https://github.com/mcicolella/awesome-lora-lorawan/issues) or [create a pull request](https://github.com/mcicolella/awesome-lora-lorawan/pulls) with your additions.

:star2: Thank you!

