# Laravel Hands On

This repository aims to provide a learning resource for people who are interested in learning Laravel.

## Description

This repository is structured into different branches, with each branch focusing on a specific topic in Laravel. Each branch contains a README file explaining a little but about that topic and providing hands-on examples and code samples.

The main goal of this repository is to offer the best practices for each Laravel topic, allowing learners to gain a solid understanding of Laravel's various aspects.

## Instructions

To get started with this Laravel learning project:

1. Explore the different branches of this repository to find the specific Laravel topic you want to learn.
2. Read the README file in each branch to understand the topic's concept and its relevance in Laravel development.
3. Follow the provided instructions and explore the accompanying code samples to gain practical experience and deepen your understanding of the topic.
4. If you have a good knowledge of Laravel and would like to contribute or enhance any branch, feel free to submit your updates to this repository.

We encourage you to actively engage with the content, experiment with the code, and explore Laravel's capabilities.

## Note

This project primarily focuses on utilizing Laravel for developing APIs. Although it starts focusing on WEB part at 40th topic but If you are using Laravel for website development, you may need to explore other projects as well. Additionally, this project assumes that you have some basic knowledge 
of Laravel. If you are entirely new to Laravel, we recommend reading the official Laravel documentation as a starting point.

With new Laravel-11 update and new Folder structure, we created a new branch [laravel-11](https://github.com/mazimez/laravel-hands-on/tree/laravel-11) with laravel-11's folder structure and it will be the new base branch and all the upcoming branch will follow that. we will re-explain all the topics that's been updated with laravel-11. the focus will be on what's exactly changed from Laravel 10 to 11 rather then explaining the actually Topic(since that's already explained in laravel-10 version)

so whenever learning about any topic, first read about that with laravel-10's version and then see how it's updated in laravel-11.

## Where to Start
- you can directly go to any branch for the topic that you want to understand, and if you want to see all the branches then following MAP that you should follow to go thorough each branch
- with laravel-11, each topic may has it's new version of laravel-11 and  if there is no change for that topic in laravel-11 then it will be shown as `same as 10`



| **Laravel-10** | **Laravel-11** |
| :-----------: | :------------: |
| [laravel-10](https://github.com/mazimez/laravel-hands-on/tree/master) | [laravel-11](https://github.com/mazimez/laravel-hands-on/tree/laravel-11) |
| [traits](https://github.com/mazimez/laravel-hands-on/tree/traits) | `same as 10` |
| [exception-handling](https://github.com/mazimez/laravel-hands-on/tree/exception-handling) | [exception-handling-v11](https://github.com/mazimez/laravel-hands-on/tree/exception-handling-v11) |
| [api-versioning](https://github.com/mazimez/laravel-hands-on/tree/api-versioning) | [api-versioning-v11](https://github.com/mazimez/laravel-hands-on/tree/api-versioning-v11) |
| [localization](https://github.com/mazimez/laravel-hands-on/tree/localization) | [localization-v11](https://github.com/mazimez/laravel-hands-on/tree/localization-v11) |
| [migration](https://github.com/mazimez/laravel-hands-on/tree/migration) | [migration-v11](https://github.com/mazimez/laravel-hands-on/tree/migration-v11) |
| [seeder-factory](https://github.com/mazimez/laravel-hands-on/tree/seeder-factory) | `same as 10` |
| [stubs](https://github.com/mazimez/laravel-hands-on/tree/stubs) | `same as 10` |
| [Auth-sanctum](https://github.com/mazimez/laravel-hands-on/tree/Auth-sanctum) | [auth-sanctum-v11](https://github.com/mazimez/laravel-hands-on/tree/auth-sanctum-v11) |
| [files-managment](https://github.com/mazimez/laravel-hands-on/tree/files-managment) | `same as 10` |
| [file-seeder](https://github.com/mazimez/laravel-hands-on/tree/file-seeder) | `same as 10` |
| [basic-crud](https://github.com/mazimez/laravel-hands-on/tree/basic-crud) | `same as 10` |
| [sorting-searching](https://github.com/mazimez/laravel-hands-on/tree/sorting-searching) | `same as 10` |
| [eloquent-relationships](https://github.com/mazimez/laravel-hands-on/tree/eloquent-relationships) | `same as 10` |
| [enhanced-crud](https://github.com/mazimez/laravel-hands-on/tree/enhanced-crud) | `same as 10` |
| [enhanced-relationship](https://github.com/mazimez/laravel-hands-on/tree/enhanced-relationship) | [enhanced-relationship-v11](https://github.com/mazimez/laravel-hands-on/tree/enhanced-relationship-v11) |
| [scope-attribute](https://github.com/mazimez/laravel-hands-on/tree/scope-attribute) | `same as 10` |
| [policies](https://github.com/mazimez/laravel-hands-on/tree/policies) | [policies-v11](https://github.com/mazimez/laravel-hands-on/tree/policies-v11) |
| [middleware](https://github.com/mazimez/laravel-hands-on/tree/middleware) | [middleware-v11](https://github.com/mazimez/laravel-hands-on/tree/middleware-v11) |
| [polymorphism-part-1](https://github.com/mazimez/laravel-hands-on/tree/polymorphism-part-1) | `same as 10` |
| [polymorphism-part-2](https://github.com/mazimez/laravel-hands-on/tree/polymorphism-part-2) | `same as 10` |
| [sending-mails](https://github.com/mazimez/laravel-hands-on/tree/sending-mails) | `same as 10` |
| [observers](https://github.com/mazimez/laravel-hands-on/tree/observers) | |
| [events-listners-queue](https://github.com/mazimez/laravel-hands-on/tree/events-listners-queue) | |
| [error-handling](https://github.com/mazimez/laravel-hands-on/tree/error-handling) | |
| [scheduler-cron](https://github.com/mazimez/laravel-hands-on/tree/scheduler-cron) | |
| [testing](https://github.com/mazimez/laravel-hands-on/tree/testing) | |
| [deployment](https://github.com/mazimez/laravel-hands-on/tree/deployment) | |
| [social-login](https://github.com/mazimez/laravel-hands-on/tree/social-login) | |
| [enhanced-storage-management](https://github.com/mazimez/laravel-hands-on/tree/enhanced-storage-management) | |
| [user-verification](https://github.com/mazimez/laravel-hands-on/tree/user-verification) | |
| [debugging-telescope](https://github.com/mazimez/laravel-hands-on/tree/debugging-telescope) | |
| [indexing](https://github.com/mazimez/laravel-hands-on/tree/indexing) | |
| [fcm-notification-part-1](https://github.com/mazimez/laravel-hands-on/tree/fcm-notification-part-1) | |
| [fcm-notification-part-2-optimization](https://github.com/mazimez/laravel-hands-on/tree/fcm-notification-part-2-optimization) | |
| [job-queues](https://github.com/mazimez/laravel-hands-on/tree/job-queues) | |
| [laravel-pint](https://github.com/mazimez/laravel-hands-on/tree/laravel-pint) | |
| [pdf-generation](https://github.com/mazimez/laravel-hands-on/tree/pdf-generation) | |
| [excel-generation](https://github.com/mazimez/laravel-hands-on/tree/excel-generation) | |
| [caching](https://github.com/mazimez/laravel-hands-on/tree/caching) | |
| [web-basics](https://github.com/mazimez/laravel-hands-on/tree/web-basics) | |
| [datatables](https://github.com/mazimez/laravel-hands-on/tree/datatables) | |
| [livewire-part-1](https://github.com/mazimez/laravel-hands-on/tree/livewire-part-1) | |
| [livewire-part-2](https://github.com/mazimez/laravel-hands-on/tree/livewire-part-2) | |
| [livewire-part-3](https://github.com/mazimez/laravel-hands-on/tree/livewire-part-3) | |


## Contributors
<table>
  <tr>
    <td align="center">
      <a href="https://github.com/mazimez">
        <img src="https://github.com/mazimez.png" width="100px;" alt="username1"/>
        <br />
        <sub><b>Mazimez</b></sub>
      </a>
    </td>
    <td align="center">
      <a href="https://github.com/chopincodeshere">
        <img src="https://github.com/chopincodeshere.png" width="100px;" alt="username2"/>
        <br />
        <sub><b>Jil Patel</b></sub>
      </a>
    </td>
  </tr>
</table>

