(function(w){
    var t = top != self ? parent.toastr : toastr ;
    var m = top != self ? parent.swal : swal ;
    // console.log(top != self);
    var toast = {
        info:function(content){
            var title = title || '提示信息';
            baseToast(content,title,'info');
        },
        error:function(content){
            var title = title || '错误信息';
            baseToast(content,title,'error');
        },
        success:function(content){
            var title = title || '成功信息';
            baseToast(content,title,'success');
        },
    };

    var msg = {
        info:function(content){
            var title = title || '提示';
            return baseAlert(content,title,'info');
        },
        success:function(content){
            var title = title || '成功';
            return baseAlert(content,title,'success');
        },
        error:function(content){
            var title = title || '错误';
            return baseAlert(content,title,'error');
        },
        confirm:function(content){
            return m({
                type: 'info',
                title: '提示',
                text: content,
                showCancelButton:true,
                cancelButtonText: "取消",
                confirmButtonText: "确定",
                closeOnClickOutside:false,
            })
        }
    }



    function baseToast(content,title,name){
        t[name](content,title,{
            positionClass: "toastr_top_right",
            containerId: "toastr_top_right",
            closeButton: !0,
            timeOut: "3000"
        })
    }

    function baseAlert(content,title,name){
        return m({
            type: name,
            title: title,
            text: content,
            cancelButtonText: "取消",
            confirmButtonText: "确定",
            closeOnClickOutside:false,
        })
    }

    w.$toast = toast ;
    w.$alert = msg ;
}(window));
