$(document).ready(function () {

    if (ClassicEditor) {

        window.editors = {} ;

        var allEditors = document.querySelectorAll('.editor');

        for (var i = 0; i < allEditors.length; i++) {
            (function(index){
                ClassicEditor.create(allEditors[index],{
                    toolbar: {
                        items: [
                            'heading',
                            '|',
                            'bold',
                            'italic',
                            'link',
                            'bulletedList',
                            'numberedList',
                            '|',
                            'outdent',
                            'indent',
                            '|',
                            'imageUpload',
                            'blockQuote',
                            'insertTable',
                            'mediaEmbed',
                            'undo',
                            'redo'
                        ]
                    },
                })
                .then(editor => {

                    var name = allEditors[index].getAttribute('name');
                    if( name ){
                        window.editors[name] = editor;
                    }else{
                        window.editors[index] = editor;
                    }
                })
                .catch(err => {
                    console.error(err.stack);
                });
            }(i))
        }
    }
})
