<?php
namespace app\web\lib;


use app\model\Card as CardModel;
use app\model\Goods as GoodsModel;
use app\model\OrderGoods as OrderGoodsModel;
use app\model\UserPay;
use app\pay\lib\Sign;
use think\exception\ValidateException;


class Order {

    private $params ;
    private $userPay ;
    public function init( $params ){

        $this->userPay = UserPay::getPayConfig();

        if( empty( $params['id'] ) ){
            throw new ValidateException('商品不存在');
        }

        if( empty( $params['type'] ) ){
            throw new ValidateException('请选择一个支付类型');
        }

        if( empty( $params['contact'] ) || strlen( $params['contact'] ) < 6 ){
            throw new ValidateException('请输入至少6位联系方式');
        }

        $goods = GoodsModel::findOrEmpty($params['id']);

        if( $goods->isEmpty() ){
            throw new ValidateException('商品不存在2');
        }

        if( $goods->status != 1 ){
            throw new ValidateException('该商品已下架');
        }

        $this->params = [
            // 商品id
            'trade_no' => 'E'.date("YmdHis") . rand(11111, 99999),
            'goods_id' => $params['id'],
            'goods_type' => $goods->type,
            'out_time' => getCurrentTime() + $this->userPay['order_validity'] ,
            'url'=> $goods->url,
            'type'=> $params['type'],
            'name' => $goods->name,
            // 价格
            'amount'=>$goods->price,
            'pay_amount'=>$goods->price,
            'contact' => $params['contact'],
        ];

        // 查一下还有库存没 2是卡密
        if( $goods->type == 2 ){
            // 创建订单前把失效的卡密返还
            OrderGoodsModel::rebackCard();
            $card = CardModel::where(['goods_id'=>$params['id'],'status'=>0])->findOrEmpty();
            if( $card->isEmpty() ){
                throw new ValidateException('该商品无库存，请选择其他商品');
            }

            $this->params['card_id'] = $card->id ;
        }

    }

    public function create(){

        if( empty( $this->params ) ){
            throw new ValidateException('请先初始化参数');
        }

        $rs = OrderGoodsModel::create($this->params);
        if( $rs === FALSE ){
            throw new ValidateException('下单失败');
        }
        if(isset($this->params['card_id'])){
            CardModel::update(['id'=>$this->params['card_id'],'status'=>1]);
        }
        return $rs ;
    }

    // 支付地址
    public function getPayUrl(){

        $key = $this->userPay['code_key'];

        // 这里固定一下参数
        $params['pid'] = $this->userPay['code'];
        // 签名就在这里生成了
        $params['return_url'] = request()->domain() . "/web/result";
        $params['notify_url'] = request()->domain() . "/web/notify";

        $params['name'] = $this->params['name'];
        $params['type'] = $this->params['type'];
        $params['out_trade_no'] = $this->params['trade_no'];
        $params['money'] = $this->params['amount'] ;

        $params['sign'] = Sign::create($params, $key);//Sign::create($params,$key) ;

        return $params ;
    }
}
