<?php
namespace app\traits;

trait ResponseTrait{

    /**
     * 成功返回
     * @param $data
     * @param int $code
     * @return \think\response\Json
     */
    protected function responseSuccess($data = '',$code = 0){

        return $this->response($data,$code,'success');
    }

    /**
     * 失败返回
     * @param $data
     * @param int $code
     * @return \think\response\Json
     */
    protected function responseError($data = '',$code = 1){
        return $this->response($data,$code,'error');
    }

    /**
     * @param $data
     * @param $code
     * @param $status
     * @return \think\response\Json
     */
    protected function response($data,$code,$status){
        $returnData = [
            'code' => $code,
            'data' => $data,
            'status' => $status,
        ];
        return \json($returnData);
    }
}
