<?php
namespace  app\pay\lib ;

use app\model\Order as OrderModel;
use app\model\UserPay;
use app\model\Qrcode as QrcodeModel;
use chillerlan\QRCode\QRCode;
use think\exception\ValidateException;

/**
 * 获取订单支付二维码类
 * Class QrcodeBuild
 * @package app\pay\lib
 */
class QRCodeBuild{

    private $params ;
    private $order ;
    private $currentTime ;

    public function init($data){
        $this->params = $data ;
        $this->currentTime = getCurrentTime() ;
        $this->checkParams();
    }

    public function checkParams(){
        $n = '_'.$this->params['trade_no'];
        $allow = session($n);

        if( $allow ){
            throw new ValidateException('请不要刷新该页面');
        }

        session($n,1);

        if( !isset($this->params['trade_no']) || empty( $this->params['trade_no'] ) ){
            throw new ValidateException('订单号不存在') ;
        }

        $order = OrderModel::where(['trade_no'=>$this->params['trade_no']])->findOrEmpty();

        if( $order->isEmpty() ){
            throw new ValidateException('订单不存在');
        }

        if( $order->status == 1 ){
            throw new ValidateException('订单已支付');
        }

        $this->order = $order ;

        if( $this->order->out_time <= $this->currentTime ){
            throw new ValidateException('订单已失效') ;
        }

        /*$payConfigs = UserPay::getPayConfig();
        $payData = [] ;*/


    }

    // 获取二维码
    public function getQrcodeImage(){
        return $this->{$this->order->type}() ;
    }

    // 获得订单信息
    public function getOrderInfo(){
        return $this->order ;
    }

    // 获取超时的时间 单位秒
    public function getOuttime(){
        return $this->order->out_time - $this->currentTime ;
    }


    // 考虑到只有2种方式，不分开了
    private function alipay(){

        $qrcodeImage = '' ;

        $payConfigs = UserPay::getPayConfig();
        // 生成二维码
        if( isset( $payConfigs['alipay_id'] ) && !empty($payConfigs['alipay_id']) ){
            $payData = [
                's'=>'money',
                'u'=>$payConfigs['alipay_id'],
                'a'=>$this->order->pay_amount,
                'm'=>$this->order->out_trade_no,
            ];

            $scanUrl = 'alipays://platformapi/startapp?appId=20000123&actionType=scan&biz_data='.json_encode($payData);
            $qrcodeImage = (new QRCode)->render($scanUrl);

        }else{
            // 读取数据库对比一下
            $qrcodeImage = $this->getDbQrcode(1);

        }

        return $qrcodeImage ;
    }

    private function wxpay(){
        $qrcodeImage = $this->getDbQrcode();
        return $qrcodeImage ;
    }

    /**
     * 这里 0 是微信 1是支付宝
     * @param int $t
     * @return QrcodeModel|array|\think\Model
     */
    private function getDbQrcode($t = 0){

        $qrcode = QrcodeModel::where([
            ['amount','in',[$this->order->pay_amount,0]],
            ['type','=',$t]
        ])->order('amount','desc')->findOrEmpty();

        if( $qrcode->isEmpty()){
            throw new ValidateException('二维码获取失败'.$t) ;
        }

        return (new QRCode)->render($qrcode->qrcode) ;
    }
}
