<?php
namespace app\pay\lib;
// 通知第三方
use app\model\UserPay;
use app\pay\lib\Sign;

class Notify{

    // 通知地址
    private $notify_url ;

    private $params = [
        // 商户pid
        'pid' => '' ,
        // 流水号
        'trade_no' => '',
        // 商家订单号
        'out_trade_no' => '',
        // 支付的类别 alipay | wxpay
        'type' => '',
        // 商品名称
        'name' => '',
        // 支付金额
        'money' => '',
        // 订单状态
        'trade_status' => 'TRADE_SUCCESS',
        // 签名
        'sign' => '' ,
        // 签名加密方式
        'sign_type' => 'MD5',
    ] ;

    // 通知地址
    /*private $notify_url ;
    // 商户pid
    private $pid ;
    // 流水号
    private $trade_no;
    // 商家订单号
    private $out_trade_no;
    // 支付的类别 alipay | wxpay
    private $type;
    // 商品名称
    private $name;
    // 支付金额
    private $money;
    // 订单状态
    private $trade_status= 'TRADE_SUCCESS';
    // 签名
    private $sign ;
    // 签名加密方式
    private $sign_type= 'MD5';*/

    public function setParams($params){

        // 传参以及验证
        $this->notify_url               = $params['notify_url'] ;

        $this->params['pid']            = $params['pid'] ;
        $this->params['trade_no']       = $params['trade_no'] ;
        $this->params['out_trade_no']   = $params['out_trade_no'] ;
        $this->params['type']           = $params['type'] ;
        $this->params['name']           = $params['name'] ;
        $this->params['money']          = $params['amount'] ;
        //$this->params['money']          = $params['pay_amount'] ;
        $this->params['trade_status']   = 'TRADE_SUCCESS' ;

        $userPay = UserPay::getPayConfig();

        $this->params['sign']           = Sign::create($this->params,$userPay['code_key']) ;
    }

    // 发送通知了
    public function send(){

        $resp = api($this->notify_url,'get',$this->params);

        if( $resp == 'success' ){
            return true ;
        }

        return false;
    }

    public function getReturnUrl(){
        return http_build_query($this->params) ;
    }
}
