<?php
namespace app\pay\controller;

use app\BaseController;
use app\model\Order as OrderModel;
use app\traits\ResponseTrait;
use app\pay\lib\Notify as Noti ;
use think\facade\Db;

class Notify extends BaseController{

    use ResponseTrait ;

    // 检测到支付成功后的回调 执行订单更改 以及通知第三方
    public function index($type , Noti $notify){

        $amount = request()->get('a','') ;

        if( empty( $amount ) ){
            return $this->responseError('参数错误a');
        }
        $currentTime = getCurrentTime();

        $order = OrderModel::where([
            ['type','=',$type],
//            ['status','=',0],
            ['pay_amount','=',$amount],
//            ['out_time','>',$currentTime]
        ])->order('id','desc')->findOrEmpty();

        if($order->isEmpty()){
            return $this->responseError('订单不存在或已过期');
        }

        $order->status = 1 ;
        $order->complete_time = $currentTime ;
        $rs = $order->save();

        if($rs === FALSE){
            return $this->responseError('修改状态失败');
        }

        // 通知第三方
        $notify->setParams($order->toArray());
        $notify->send();

        return $this->responseSuccess('操作成功');
    }
}
