<?php


namespace app\model;
use \think\Model;

/**
 * 管理员模型
 * Class Master
 * @package app\model
 */
class UserPay extends Model {
    protected $pk = 'user_id';

    public static function getCodeAttr($value){
        return !$value ? strtolower(generateRandom(9)) :$value ;
    }

    public static function getCodeKeyAttr($value){
        return !$value ? strtolower(generateRandom(16)) :$value ;
    }

    public static function getCode(){
        return strtolower(generateRandom(9));
    }

    public static function getAlipayCookie($key){
        $data = self::where(['code'=>$key])->findOrEmpty();
        return $data->isEmpty() ? false : $data->getAttr('alipay_cookie');
    }

    public static function getPayConfig(){
        $config = cache('payConfig') ;

        if( is_null($config) || empty( $config ) ){

            $config = self::where([])->order('user_id','desc')->find();

            if( is_null($config) ){
                return [] ;
            }

            $config = $config->toArray() ;
            cache('payConfig',$config) ;
        }
        return $config ;
    }
}
