<?php

namespace app\model;
use think\Model;

/**
 * 订单模型
 * Class Order
 * @package app\model
 */
class Order extends Model {

    protected $autoWriteTimestamp = true;

    public static function getTypes(){
        return ['alipay'=>'支付宝','wxpay'=>'微信'] ;
    }

    public function getTypeTextAttr($value,$data){
        //$types = ['alipay'=>'支付宝','wechat'=>'微信'];
        return self::getTypes()[$data['type']];
    }

    // 已付款
    public function getStatusTextAttr($value,$data){
        $status = [
            '0'=>['text'=>'未付款','style'=>'light'],
            '1'=>['text'=>'已付款','style'=>'success'],
            '2'=>['text'=>'完成','style'=>'dark']];
        return $status[$data['status']] ;
    }
}
