<?php

namespace app\model;

use think\Model;

class Card extends Model {
    protected $autoWriteTimestamp = true;

    public function getStatusTextAttr($value,$data){
        $status = [
            '0'=>['text'=>'正常','style'=>'success'],
            '1'=>['text'=>'出售中','style'=>'warning'],
            '2'=>['text'=>'出售','style'=>'info']
        ];
        return $status[$data['status']] ;
    }


    public function goods() {
        return $this->hasOne(Goods::class, 'id','goods_id')->bind(['g_status'=>'status']);
    }
}
