<?php
declare (strict_types = 1);

namespace app\middleware;

use think\exception\ValidateException;

/**
 * 验证登录中间件
 * Class Auth
 * @package app\middleware
 */
class CsrfToken
{
    /**
     * 处理请求
     *
     * @param \think\Request $request
     * @param \Closure       $next
     * @return Response
     */
    public function handle($request, \Closure $next)
    {
        // 验证ajax csrf
        if( $request->isAjax() ){
            $check = $request->checkToken('__token__');
            if(false === $check) {
                throw new ValidateException('请刷新重试');
            }
        }
        return $next($request);
    }
}
