<?php
namespace app\common\sms;

use AlibabaCloud\SDK\Dysmsapi\V20170525\Dysmsapi;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\SendSmsRequest;
use Darabonba\OpenApi\Models\Config;

class Sms2 implements SmsI {
    protected $error ;
    public function send($data) {

        // TODO: Implement send() method.
        $config = new Config([
            // 您的AccessKey ID
            "accessKeyId" => $data['sid'],
            // 您的AccessKey Secret
            "accessKeySecret" => $data['token']
        ]);

        $sms = new Dysmsapi($config);
        $response = $sms->sendSms($this->buildData($data));
        $response = $response->body ;
        if( $response->code != 'ok'){
            $this->error = $response->message;
            return false ;
        }
        return true ;
    }

    public function error() {
        // TODO: Implement error() method.
        return $this->error;
    }

    public function buildData($data){

        $sendSmsRequest = new SendSmsRequest([
            'phoneNumbers'=>$data['to'],
            'signName' =>$data['signName'],
            'templateCode'=>$data['templateCode'],
            'templateParam'=> $data['templateParam'] ?? '',
        ]);

        return $sendSmsRequest ;
    }

}
