<?php
namespace app\common\sms;

use Curl\Curl;

class Sms1 implements SmsI {

    protected $url = "https://api.smsbao.com/sms";
    protected $error;
    protected $data;

    public function send($data) {
        // TODO: Implement send() method.
        $curl = new Curl() ;
        //$curl->setHeader('Content-type','application/x-www-form-urlencoded');
        //print_r($this->buildData($data));
        $curl->get($this->url.'?'.http_build_query($this->buildData($data)));
        $response = $curl->getResponse();

        //$curl->close();

        if ($curl->error) {
            $this->error = $curl->error_code;
            return false ;
        }
        //$response = json_decode($response);

        if( $response != 0 ){
            $this->error = $response;
            return false ;
        }

        return $response ;
    }

    public function error() {
        // TODO: Implement error() method.
        $statusStr = array(
            "0" => "短信发送成功",
            "-1" => "参数不全",
            "-2" => "服务器空间不支持,请确认支持curl或者fsocket，联系您的空间商解决或者更换空间！",
            "30" => "密码错误",
            "40" => "账号不存在",
            "41" => "余额不足",
            "42" => "帐户已过期",
            "43" => "IP地址限制",
            "50" => "内容含有敏感词"
        );
        return $statusStr[$this->error];
    }

    public function buildData($data){

        //$data['timestamp'] = getCurrentMicrotime() ;

        return [
//            'respDataType'=>'json',
            'u'=>$data['sid'],
            'p'=>md5($data['token']),
            'c'=>$data['content'],
            'm'=>$data['to'],
//            'timestamp'=>$data['timestamp'],
            //'sig'=>$this->sign($data)
        ];
    }

    private function sign($data){
        return md5($data['sid'].$data['token'].$data['timestamp']);
    }
}
