<?php


namespace app\common;


use app\model\EmailStyle;

class Email {

    public static function send($t=0){

        $config = config('email');
        $dropTime = cache('email_drop_time') ;
        $currentTime = getCurrentTime();

        if( $t == 0 && !is_null($dropTime) && $dropTime > $currentTime){
            return false ;
        }

        $d = EmailStyle::where(['type' => $t])->findOrEmpty();
        //print_r($d);
        if ($d->isEmpty()) {
            return false ;
        }

        $smtp = new Smtp($config['smtp'],$config['port'],true,$config['username'],$config['userpass']);
        if( !$smtp->sendmail($config['test'],$config['username'],$d['title'],$d['content'],'HTML') ) {
            return false;
        }
        if($t == 0){
            cache('email_drop_time',$currentTime+60);
        }
        return true;
    }
}
