<?php
namespace app\admin\validate;

use think\Validate;
/**
 * 免挂配置
 * Class Master
 * @package app\admin\validate
 */
class Visa extends Validate{

    protected $rule =   [
        'code'   => 'require|length:9',
        'code_key'   => 'require|length:16',
        'wechat_name' => 'require',
        'wechat_nickname' => 'require',
    ];

    protected $message  =   [
        'code.require'               => '请填写ID',
        'code.length'                => 'ID的长度为9位字符串',
        'code_key.require'            => '请填写KEY',
        'code_key.length'             => 'KEY的长度为16位字符串',
        'wechat_name.require'        => '请填写微信昵称',
        'wechat_nickname.require'    => '请填写微信实名',
    ];

    protected $scene = [
        'wechat'  =>  ['wechat_name','wechat_nickname'],
        'base'  =>  ['code','code_key'],
    ];
}
