<?php
namespace app\admin\validate;

use think\Validate;
use app\model\Qrcode as QrcodeModel;
/**
 * 二维码验证
 * Class Master
 * @package app\admin\validate
 */
class Qrcode extends Validate{

    protected $rule =   [
        'qrcodeImage'   => 'require',
        'qrcode'        => 'require',
        'amount'        => 'requireCallback:checkAmountUnique'
    ];

    protected $message  =   [
        'qrcodeImage.require'      => '请先上传二维码图片',
        'qrcode.require'           => '二维码图片识别失败',
        'amount.requireCallback'   => '请输入金额，通用二维码只能存在一张',
    ];

    // 自定义验证规则
    protected function checkAmountUnique($value, $data=[]){
        if( !$value ){
            $value = 0;
            $result = QrcodeModel::where(['type'=>$data['type'],'amount'=>$value])->findOrEmpty();
            if( !$result->isEmpty() ){
                return true ;
            }
        }
        return false ;
    }
}
