<?php
namespace app\admin\validate;

use think\Validate;
use app\model\Master as MasterModel ;
/**
 * 管理员验证
 * Class Master
 * @package app\admin\validate
 */
class Master extends Validate{

    protected $rule =   [
        'username'  =>  'require|notbetween:5,12|checkUserUnique',
        'userpass' => 'require|alphaDash|notbetween:6,18',

        'nuserpass'   => 'require|alphaDash|notbetween:6,18|confirm:reuserpass|different:userpass',
        'reuserpass' => 'confirm:nuserpass',

        'usercode' => 'require|captcha'
    ];

    protected $message  =   [
        'username.require'              => '请输入账号',
        'username.notbetween'           => '账号必须在5-12位之间',
        'username.checkUserUnique'      => '用户名不存在',
        'userpass.require'              => '请输入密码',
        'userpass.alphaDash'              => '密码只能位字母数字下划线',
        'userpass.notbetween'           => '密码必须在6-18位之间',
        'usercode.require'           => '请输入验证码',
        'usercode.captcha'           => '验证码错误',

        'nuserpass.alphaDash'              => '密码只能位字母数字下划线',
        'nuserpass.different'              => '新旧密码不能相同',
        'nuserpass.require'          => '请输入新密码',
        'nuserpass.notbetween'       => '密码必须在6,18位之间',
        'nuserpass.confirm'          => '新密码跟确认密码不一致',
        'reuserpass.confirm'          => '确认密码必须跟新密码相同',
    ];

    // 自定义验证规则
    protected function checkUserUnique($value, $rule, $data=[]){

        $master = MasterModel::where('username',$value)->findOrEmpty();
        return $master->isEmpty() ? '用户名不存在' : true ;
    }

    protected $scene = [
        'auth'  =>  ['username','userpass','usercode'],
        'pass'  =>  ['userpass','nuserpass','reuserpass'],
    ];
}
