<?php
use think\facade\Route;

Route::get('/','Index/index');
Route::get('/desk','Index/main');

Route::get('/config','Configure/index');
Route::post('/config','Configure/store');

// 上传相关 目前就图片
Route::post('upload/:type','Upload/index');
Route::get('upload/delete','Upload/destroy');


// 邮件相关
Route::group('email',function(){
    Route::get('/','Email/index');
    Route::post('/','Email/store');
    Route::post('/test','Email/test');
});

// 短信相关
Route::group('sms',function(){
    Route::get('/','Sms/index');
    Route::post('/','Sms/store');
    Route::post('/test','Sms/test');
});

// 免签配置
Route::group('visa',function(){
    Route::get('','Visa/index');
    Route::post(':type','Visa/store') ;
});

Route::get('/alipay','Alipay/index');
Route::post('/alipay','Alipay/store');
Route::get('/alipaycode','Alipay/refreshPayCode');
Route::get('/alipaycookie/:id','Alipay/getAlipayCookie');
Route::get('/alipaycodeid','Alipay/getAlipayCodeId');

Route::group('qrcode',function(){
    // 解码
    Route::post('decode','Qrcode/qrcodeDecode');
    Route::post(':ids/delete','Qrcode/destroy');
    Route::get('','Qrcode/index');
    Route::get('add','Qrcode/add');
    Route::post('','Qrcode/store');

});


Route::get('/wechat','Visa/wechat');

Route::get('/pass','Master/pass');
Route::post('/pass','Master/modPass');

// 订单
Route::get('/order','Order/index');
Route::post('/order/:ids/delete','Order/destroy');
Route::post('/order/:ids/status','Order/changeStatus');

Route::get('/ordergoods','OrderGoods/index');
Route::post('/ordergoods/:ids/delete','OrderGoods/destroy');

// 商品
Route::group('goods',function(){

    Route::get('','Goods/index');
    Route::get('/add','Goods/show');

    // 读取
    Route::get('/:id','Goods/show');

    Route::post('/','Goods/store');
    Route::post('/:ids/delete','Goods/destroy');
});

// 卡密
Route::group('card',function(){

    Route::get('','Card/index');
    Route::get('/add/:id','Card/show');
    Route::post('/','Card/store');
    Route::post('/:ids/delete','Card/destroy');
});

Route::group('goodscls',function(){

    Route::get('','GoodsCls/index');
    Route::post('','GoodsCls/store');

    Route::post(':ids/delete','GoodsCls/destroy');
});


Route::get('/login','Auth/index');
Route::post('/login','Auth/login');
Route::get('/logout','Auth/logout');
