<?php


namespace app\admin\controller;

use app\model\Master;
use app\model\UserPay;
use Curl\Curl;
use http\Client\Curl\User;
use think\App;
use think\facade\View;

/**
 * 免签控制器
 * Class Visa
 * @package app\admin\controller
 */

class Visa extends AdminController {

    public function __construct(App $app) {
        parent::__construct($app);
    }

    public function index(){

        $pay = UserPay::findOrEmpty($this->user['id']);
        View::assign('pay',$pay) ;
        return View::fetch();
    }

    public function wechat(){

        $pay = UserPay::findOrEmpty($this->user['id']);
        View::assign('pay',$pay) ;
        return view();
    }

    public function store($type){

        $data = request()->post();

        $validated = $this->validate($data, 'Visa.'.$type);

        if ($validated !== true) {
            return $this->responseError($validated);
        }

        $userPay = UserPay::findOrEmpty($this->user['id']) ;
        $data['user_id'] = $this->user['id'] ;

        if( $userPay->isEmpty() ){
            $rs = UserPay::create($data) ;
        }else{
            $rs = UserPay::update($data) ;
        }

        if( $rs !== FALSE ){
            $pay = UserPay::findOrEmpty($this->user['id'])->toArray();
            cache('payConfig',$pay) ;
            return $this->responseSuccess();
        }

        return $this->responseError('更新失败');
    }


}

