<?php

namespace app\admin\controller;

use app\model\OrderGoods as OrderGoodsModel;
use think\facade\Db;
use think\facade\View;

class OrderGoods extends AdminController {

    public function index() {

        // 筛选
        $params = request()->get();
        $needs = ['time','trade_no','status','type'] ;
        $where  =  [] ;

        foreach( $params as $key => $val ){

            if( ( $val === '' ) || !in_array($key,$needs)){
                continue ;
            }

            if( $key == 'time' ){
                if( empty( $val ) ){
                    continue;

                }
                if( strstr( $val , ' ' ) === false ){
                    continue;
                }

                list( $s , $e ) = explode(" ", $val ) ;

                if( $s != $e && $s < $e ){
                    array_unshift($where,['create_time','between',[getCurrentTime($s),getCurrentTime($e)]]);
                }

                continue ;
            }

            array_unshift($where,[$key,'=',$val]) ;
        }
        OrderGoodsModel::rebackCard();
        $list = OrderGoodsModel::where($where)
            ->order('create_time', 'desc')
            ->paginate(20);

        //View::assign('')
        View::assign('list',$list);
        View::assign('page',$list->render() ) ;

        return view();
    }

    // 删除
    public function destroy($ids){

        if( empty( $ids ) ){
            return $this->responseError('删除id不存在');
        }

        $id = explode(',',$ids);
        $rs     = OrderGoodsModel::destroy($id);

        if( $rs !== false ){

            return $this->responseSuccess();
        }
        return $this->responseError('删除失败');
    }

}
