<?php

namespace app\admin\controller;

use app\model\Order as OrderModel;
use think\facade\Db;
use think\facade\View;

class Order extends AdminController {

    public function index() {

        // 筛选
        $params = request()->get();
        $needs = ['time','out_trade_no','status','type'] ;
        $where  =  [] ;

        foreach( $params as $key => $val ){

            if( empty( $val ) || !in_array($key,$needs)){
                continue ;
            }

            if( $key == 'time' ){
                if( empty( $val ) ){
                    continue;

                }
                if( strstr( $val , ' ' ) === false ){
                    continue;
                }

                list( $s , $e ) = explode(" ", $val ) ;

                if( $s != $e && $s < $e ){
                    array_unshift($where,['create_time','between',[getCurrentTime($s),getCurrentTime($e)]]);
                }

                continue ;
            }

            array_unshift($where,[$key,'=',$val]) ;
        }

        $list = OrderModel::where($where)
            ->order('create_time', 'desc')
            ->paginate(20);

        //View::assign('')
        View::assign('list',$list);
        View::assign('page',$list->render() ) ;

        return view();
    }

    public function changeStatus($ids){

        if( empty( $ids ) ){
            return $this->responseError('id不存在');
        }

        $id = explode(',',$ids);
        $orderModel = new OrderModel;
        $data = $orderModel->select($id);
        $list = [] ;

        foreach( $data as $value){
            array_unshift($list,[
                'id'=> $value->id,
                'status' =>1
            ]);
        }
        $rs = $orderModel->saveAll($list);
        if( $rs === FALSE){
            return $this->responseError('操作失败');
        }

        return $this->responseSuccess();
    }

    // 删除
    public function destroy($ids){

        if( empty( $ids ) ){
            return $this->responseError('删除id不存在');
        }

        $id = explode(',',$ids);
        $rs     = OrderModel::destroy($id);

        if( $rs !== false ){

            return $this->responseSuccess();
        }
        return $this->responseError('删除失败');
    }

}
