<?php
namespace app\admin\controller ;

use think\facade\View;
use app\model\Order as OrderModel ;
use app\model\Qrcode as QrcodeModel ;
use app\model\Goods as  GoodsModel ;
use app\model\OrderGoods as  OrderGoodsModel ;
/**
 * 后台首页管理
 * Class Index
 * @package app\admin\controller
 */
class Index extends AdminController{

    public function index(){
        return View::fetch();
    }

    public function main(){

        $todayTime = getCurrentTime(date('Y-m-d') ) ;
        // 订单收款总金额
        $d['amount_total'] = OrderModel::where(['status'=>1])->sum('pay_amount') ;
        // 订单数量
        $d['order_count'] = OrderModel::where(['status'=>1])->count() ;
        //$d['order_total'] = OrderModel::where(['status'=>1,'create_time'])->count('pay_amount') ;
        // 二维码数量
        $d['qrcode_count'] = QrcodeModel::count();
        // 支付宝收款
        $d['alipay_total'] = OrderModel::where(['status'=>1,'type'=>'alipay'])->sum('pay_amount');
        // 微信收款
        $d['wechat_total'] = OrderModel::where(['status'=>1,'type'=>'wechat'])->sum('pay_amount');
        // 今日订单收款
        $d['today_amount_total'] = OrderModel::where([['status','=',1],['create_time','>',$todayTime]])->sum('pay_amount') ;
        $d['goods_count'] = GoodsModel::count();

        $d['goods_order_count'] = OrderGoodsModel::count();
        $d['goods_order_total'] = OrderGoodsModel::where(['status'=>1])->sum('pay_amount');
        $d['tgo_amount_total'] = OrderGoodsModel::where([['status','=',1],['create_time','>',$todayTime]])->sum('pay_amount') ;

        View::assign('d',$d) ;
        
        
        $question=json_decode(@file_get_contents("https://www.yc88.net/helpapi/"),true);
        
         View::assign('question',$question);
        return View::fetch();
    }
}

