<?php
namespace app\admin\controller;

use app\model\GoodsCls as GoodsClsModel;
use think\facade\View;

class GoodsCls extends AdminController{

    public function index(){
        $list = GoodsClsModel::where([])->order('sort','asc')->select();
        View::assign('list',$list) ;
        return view();
    }

    public function store(){

        $data = request()->post();
        $validated = $this->validate($data,'GoodsCls');
        if( $validated !== true  ){
            $this->responseError($validated);
        }
        if( empty($data['id']) ){
            $rs = GoodsClsModel::create($data) ;
        }else{
            $rs = GoodsClsModel::update($data) ;
        }
        if( $rs !== FALSE ){
            return $this->responseSuccess($rs) ;
        }

        return $this->responseError('操作失败') ;
    }


    // 删除
    public function destroy($ids){

        if( empty( $ids ) ){
            return $this->responseError('删除id不存在');
        }

        $cls = GoodsClsModel::has('goods','>',0)->findOrEmpty($ids) ;

        if( !$cls->isEmpty() ){
            return $this->responseError('该分类下有商品');
        }

        $rs     = GoodsClsModel::destroy($ids);

        if( $rs !== false ){
            return $this->responseSuccess();
        }

        return $this->responseError('删除失败');
    }
}

