<?php

namespace app\admin\controller;

use app\model\Goods as GoodsModel;
use app\model\GoodsCls as GoodsClsModel;
use Psr\Log\AbstractLogger;
use think\facade\Db;
use think\facade\View;

class Goods extends AdminController {

    public function index() {

        // 筛选
        $params = request()->get();
        $needs = ['name','status','cls_id'] ;
        $where  =  [] ;

        foreach( $params as $key => $val ){

            if( ( empty( $val ) && $val === '' ) || !in_array($key,$needs)){
                continue ;
            }

            if( $key == 'name' ){
                array_unshift($where,[$key,'like','%'.$val.'%']) ;
                continue;
            }

            array_unshift($where,[$key,'=',$val]) ;
        }

        $list = GoodsModel::with('cls')->where($where)->order('id', 'desc')->paginate(20);

        $goodsCls = GoodsClsModel::getGoodsCls();
        View::assign('goodsCls', $goodsCls);
        View::assign('list', $list);
        View::assign('page', $list->render());
        return view();
    }

    public function show($id = '') {

        $goods = [];

        if( !empty( $id ) ){
            $goods = GoodsModel::findOrEmpty($id);
            if( $goods->isEmpty() ){
                return $this->responseError('商品未找到');
            }
        }

        $goodsCls = GoodsClsModel::getGoodsCls();
        View::assign('goods',$goods) ;
        View::assign('goodsCls', $goodsCls);
        return view();
    }

    public function store() {

        $data = request()->post();
        $validated = $this->validate($data, 'Goods');

        if ($validated !== true) {
            $this->responseError($validated);
        }

        $movePath = '';
        $file = '';

        if (!empty($data['qrcodeImage'])) {

            $data['image'] = str_replace('temps/', '', $data['qrcodeImage']);
            $file = getFilePath($data['qrcodeImage'], true);
            $movePath = str_replace('/temps', '', $file);
            if (moveFile($file, $movePath) !== true) {
                return $this->responseError('文件移动失败');
            }
        }

        if (empty($data['id'])) {
            $rs = GoodsModel::create($data);
        } else {
            $rs = GoodsModel::update($data);
        }
        if ($rs !== FALSE) {

            if( !empty( $data['sourceImage'] && !empty( $data['image'] ) ) ){
                removeFile(getFilePath($data['sourceImage'],1)) ;
            }

            return $this->responseSuccess($rs);
        }

        // 失败了把文件还回去
        moveFile($movePath, $file);

        return $this->responseError('操作失败');
    }


    // 删除
    public function destroy($ids) {

        if (empty($ids)) {
            return $this->responseError('删除id不存在');
        }

        $id = explode(',', $ids);


        $list = GoodsModel::select(($id));
        $count = \app\model\Card::where('status','<',2)->whereIn('goods_id',$id)->count();

        if( $count > 0 ){
            return $this->responseError('该商品下有未出售卡密无法删除');
        }

        $rs = GoodsModel::destroy($id);

        if ($rs !== false) {
            foreach( $list as $value){
                removeFile(getFilePath($value->image,1));
            }
            return $this->responseSuccess();
        }

        return $this->responseError('删除失败');
    }
}

