<?php
namespace app\admin\controller;

use app\model\Website;
use app\Request;
use think\facade\Cache;
use think\facade\View;

/**
 * 网站配置
 * Class Configure
 * @package app\admin\controller
 */
class Configure extends AdminController{

    public function index(Request $request){

        $website = getWebsite() ;
        View::assign('website',$website);
        return View::fetch();
    }

    public function store(Request $request){

        $data = $request->post() ;
        $id = $data['id'] ;

        $website = Website::findOrEmpty($id);
        // 空表
        if( $website->isEmpty() ){
            $website = Website::create($data);
        }else{
            $website = Website::update($data);
        }
        $website = $website->toArray();
        // 写入缓存
        cache('website',$website);

        return $this->responseSuccess($website);
    }
}
