<?php

namespace app\admin\controller;

use app\model\Card as CardModel;
use app\model\OrderGoods;
use app\model\OrderGoods as OrderGoodsModel;
use think\facade\Db;
use think\facade\View;

class Card extends AdminController {

    public function index() {

        // 筛选
        $params = request()->get();
        $needs = ['name', 'status'];
        $where = [];
        $hasWhere = [] ;
        foreach ($params as $key => $val) {

            if ((empty($val) && $val === '') || !in_array($key, $needs)) {
                continue;
            }

            if ($key == 'name') {
                array_unshift($hasWhere, [$key, 'like', '%' . $val . '%']);
                continue;
            }

            array_unshift($where, ['far_card.'.$key, '=', $val]);
        }

        $list = CardModel::hasWhere('goods',$hasWhere)->where($where)
            ->order('id', 'desc')
            ->paginate(20);

        OrderGoodsModel::rebackCard();
        View::assign('list', $list);
        View::assign('page', $list->render());
        return view();
    }

    public function show($id) {

        $goods = \app\model\Goods::findOrEmpty($id);
        View::assign('goods',$goods) ;
        return view();
    }

    public function store() {

        $card = request()->post('card');
        $re = request()->post('re');
        $goods_id = request()->post('goods_id') ;

        if( empty( $card ) ){
            return $this->responseError('请输入卡密');
        }

        $card = str_replace("\r","",$card) ;

        $item = explode( "\n",$card);
        $data = [] ;
        $names = [] ;
        foreach( $item as $value ){

            $name = $value ;
            $v = '' ;

            if( strstr($value,';') != false ){
                list( $name , $v ) = explode(';',$value) ;
            }

            if( empty($name) ){
                return $this->responseError('卡号必须输入');
            }

            if( in_array($name,$names) ){
                if( $re == 1 ) continue ;

                return $this->responseError('请不要添加相同的卡号');
            }

            array_unshift($names,$name);

            array_unshift($data,[
                'card_no' =>$name ,
                'card_pass'=> $v,
                'goods_id' =>$goods_id,
            ]);

        }

        try {
            $cardModel = new CardModel;
            $rs = $cardModel->saveAll($data) ;
        }catch (\Exception $exception){
            $exception->getCode() ;
            if( strstr($exception->getMessage() , '1062') !== false ){
                return $this->responseError( '添加的卡号跟现有的重复');
            }
            return $this->responseError( '添加失败');
        }


        return $this->responseSuccess();
    }


    // 删除
    public function destroy($ids) {

        if (empty($ids)) {
            return $this->responseError('删除id不存在');
        }

        $id = explode(',', $ids);
        $count = CardModel::where('status',1)->whereIn('id',$id)->count() ;

        if( $count > 0 ){
            return $this->responseError('出售中的卡密无法删除');
        }

        $rs = CardModel::destroy($id);

        if ($rs !== false) {
            return $this->responseSuccess();
        }

        return $this->responseError('删除失败');
    }
}

