<?php

namespace app\admin\controller;

use think\facade\View;
use app\model\Master as MasterM ;
/**
 * 登录验证控制器
 * Class Auth
 * @package app\admin\controller
 */
class Auth extends AdminController {

    public function index() {
        return View::fetch();
    }

    // 注销登录
    public function logout(){
        session('master',null);

    }
    // 验证登录
    public function login() {

        $data = request()->post();
        $validated = $this->validate($data, 'Master.auth');

        if ($validated !== true) {
            return $this->responseError($validated);
        }

        // 通过验证
        $master = MasterM::where(['username'=>$data['username']])->findOrEmpty() ;
        if( $master->isEmpty() ){
            return $this->responseError('用户不存在');
        }

        if( $master['userpass'] !== MasterM::entrySalt($data['userpass'],$master['salt']) ){
            return $this->responseError('用户或密码错误');
        }

        session('master',['id'=>$master->id,'username'=>$master->username]) ;

        return $this->responseSuccess($this->admin_root.'/');
    }
}
