<?php


namespace app\admin\controller;

use app\model\Master;
use app\model\UserPay;
use Curl\Curl;
use http\Client\Curl\User;
use think\facade\View;

/**
 * 支付宝配置控制器
 * Class Alipay
 * @package app\admin\controller
 */
 
 
 $isXLoadPlugin = extension_loaded('XLOAD') ;
$text = '' ;
if( !$isXLoadPlugin ){
    $text = "<div class='container'>
    本系统免费使用，需要安装XLoad组件才可以使用，再次说明本系统不收费<br><br>您没有安装组件，该系统需要XLoad插件才能正常访问，<a href=\"/yc88net.php\">点击前往安装扩展</a><br><br>交流群：<a target=\"_blank\" href=\"https://qm.qq.com/cgi-bin/qm/qr?k=uOvymUxIt95mlywfHJeb6hUyEi3MNXvp&jump_from=webapi\">732727055</a>  官方网站 <a href=\"https://www.yc88.net\" target=\"_blank\" >www.yc88.net </a>
</div>";
exit("<style>.container{margin:120px auto 0px;width:500px;padding:50px;border:#ccc solid 1px;background:#f2f2f3;text-align:center;color:#000;} </style> $text ");
	}


class Alipay extends AdminController {

    private $cookieUrl = "http://cookie.codepay9.cn/Cookies_Api.php" ;


    public function refreshPayCode(){
        $data = $this->buildPayCode() ;
        return $this->responseSuccess($data) ;
    }

    public function index(){

        $userPay = UserPay::findOrEmpty($this->user['id']) ;

        $codes = $this->buildPayCode();
        $code = $codes['code'];
        $codeUrl = $codes['codeUrl'] ;

        $alipayCookie = '' ;

        if( !$userPay->isEmpty() && !empty( $userPay->code ) ){
            $code = $userPay->code ;
            $codeUrl = substr($codeUrl,0,strlen($codeUrl)-9).$code;
            $alipayCookie = $userPay->alipay_cookie;
        }

        $dataStatusResponse = api($codeUrl);
        // 默认失败
        $status = 0 ;

        if( $dataStatusResponse !== FALSE ){
            $dataStatusResponse = json_decode($dataStatusResponse);
            if( $dataStatusResponse->code == 0 ){
                $status = 1 ;
            }
        }

        View::assign('status',$status);
        View::assign('codeUrl',$codeUrl);
        View::assign('alipayCookie',$alipayCookie);
        View::assign('code',$code);
        return view();
    }

    public function getAlipayCookie($id){

        if( empty($id) ){
            return $this->responseError('参数错误') ;
        }
        $response = api($this->cookieUrl.'?act=Get_Cookie&id='.$id);

        if( $response === FALSE ){
            return $this->responseError('获取cookie失败') ;
        }

        $response = json_decode($response) ;
        if( !is_null( $response->cookie ) ){
            $response->cookie = base64_decode($response->cookie);
        }
        return $this->responseSuccess($response) ;
    }

    // 获取codeid
    public function getAlipayCodeId(){

        $response = api($this->cookieUrl."?act=Get_QrUrl");

        if( $response === FALSE ){
            return $this->responseError('请求失败');
        }
        $response = json_decode($response) ;

        if( $response->code != 1 ){
            return $this->responseError('id获取失败');
        }
        // 等7秒看是否生成;
        sleep(10);
        // 这里连续获取10秒才能稳定获得
        //$id = '87342179';
        $resp = api($this->cookieUrl."?act=QrUrl&id=".$response->id);

        if( $resp === FALSE ){
            return $this->responseError('二维码请求失败');
        }

        $resp = json_decode($resp) ;
        if( $resp->code != 1 ){
            return $this->responseError('二维码获取失败');
        }

        return $this->responseSuccess($resp);

    }

    public function store(){

        $cookie = request()->post('alipay_cookie');

        if( empty( $cookie) ){
            return $this->responseError('请填写cookie');
        }

        $userPay = UserPay::findOrEmpty($this->user['id']);
        // 不存在则创建
        if( $userPay->isEmpty() ){
            //
            //return $this->responseError('用户读取失败，请重新登录尝试');
            $rs = UserPay::create([
                'user_id'=>$this->user['id'],
                'alipay_cookie'=>$cookie,
            ]);
        }else{
            $userPay->alipay_cookie = $cookie ;
            $rs = $userPay->save();
        }

        if( $rs === FALSE ){
            return $this->responseError('保存失败');
        }

        $userPay = UserPay::findOrEmpty($this->user['id']);
        if( !$userPay->isEmpty() ){
            cache('payConfig',$userPay->toArray());
        }

        return $this->responseSuccess();

    }

    public function wechat(){
        return view();
    }

    private function buildPayCode(){
        $code = strtolower(generateRandom(9)) ;
        $codeUrl = request()->domain().'/corn/'.$code ;
        return ['code'=>$code,'codeUrl'=>$codeUrl] ;
    }
}
