<?php
namespace app\admin\controller;

use app\BaseController;
use app\traits\ResponseTrait;
use think\App;
use think\facade\View;

/**
 * 后台管理控制器
 * Class AdminController
 * @package app\admin\controller
 */
class AdminController extends BaseController {

    use ResponseTrait;
    protected $admin_root;
    protected $user ;

    public function __construct(App $app) {
        parent::__construct($app);
        $this->admin_root = request()->rootUrl();

        $this->user = session('master') ;
        // 应用根目录
        View::assign('admin_root',$this->admin_root);
        View::assign('user',$this->user);
    }
}
